/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.web.context;

import com.addonengine.addons.analytics.service.confluence.LicenseService;
import com.addonengine.addons.analytics.service.confluence.model.LicenseStatus;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b0\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/addonengine/addons/analytics/web/context/LicenseContext;", "", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "licenseService", "Lcom/addonengine/addons/analytics/service/confluence/LicenseService;", "<init>", "(Lcom/atlassian/plugin/PluginAccessor;Lcom/addonengine/addons/analytics/service/confluence/LicenseService;)V", "errorMessageDetails", "Lkotlin/Pair;", "", "", "getErrorMessageDetails", "()Lkotlin/Pair;", "isValid", "", "()Z", "analytics"})
public final class LicenseContext {
    @NotNull
    private final PluginAccessor pluginAccessor;
    @NotNull
    private final LicenseService licenseService;

    @Inject
    public LicenseContext(@ComponentImport @NotNull PluginAccessor pluginAccessor, @NotNull LicenseService licenseService) {
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        Intrinsics.checkNotNullParameter((Object)licenseService, (String)"licenseService");
        this.pluginAccessor = pluginAccessor;
        this.licenseService = licenseService;
    }

    @NotNull
    public final Pair<String, Object[]> getErrorMessageDetails() {
        String addonKey = "com.addonengine.analytics";
        return switch (WhenMappings.$EnumSwitchMapping$0[this.licenseService.getStatus().ordinal()]) {
            case 1 -> new Pair((Object)"", (Object)new Object[0]);
            case 2 -> new Pair((Object)"com.addonengine.addons.analytics.license.unlicensed", (Object)new Object[0]);
            case 3 -> new Pair((Object)"com.addonengine.addons.analytics.license.expired", (Object)new Object[0]);
            case 4 -> new Pair((Object)"com.addonengine.addons.analytics.license.typeMismatch", (Object)new Object[0]);
            case 5 -> {
                int licensedUserCount = this.licenseService.getLicensedUserCount();
                Integer[] var3_4 = new Integer[]{licensedUserCount};
                Pair v1 = new Pair((Object)"com.addonengine.addons.analytics.license.userMismatch", (Object)var3_4);
                yield v1;
            }
            case 6 -> new Pair((Object)"com.addonengine.addons.analytics.license.editionMismatch", (Object)new Object[0]);
            case 7 -> new Pair((Object)"com.addonengine.addons.analytics.license.roleExceeded", (Object)new Object[0]);
            case 8 -> new Pair((Object)"com.addonengine.addons.analytics.license.roleUndefined", (Object)new Object[0]);
            case 9 -> {
                String version = this.pluginAccessor.getPlugin(addonKey).getPluginInformation().getVersion();
                String[] var3_5 = new String[]{version};
                Pair v2 = new Pair((Object)"com.addonengine.addons.analytics.license.versionMismatch", (Object)var3_5);
                yield v2;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean isValid() {
        return this.licenseService.getStatus() == LicenseStatus.VALID;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LicenseStatus.values().length];
            try {
                nArray[LicenseStatus.VALID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseStatus.UNLICENSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseStatus.EXPIRED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseStatus.TYPE_MISMATCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseStatus.USER_MISMATCH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseStatus.EDITION_MISMATCH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseStatus.ROLE_EXCEEDED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseStatus.ROLE_UNDEFINED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseStatus.VERSION_MISMATCH.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

