/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.quicknav.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.core.SearchContext;
import com.atlassian.confluence.internal.api.security.ConfluenceScopesRequestCache;
import com.atlassian.confluence.search.actions.json.ContentNameSearchResult;
import com.atlassian.confluence.search.contentnames.ContentNameSearchContext;
import com.atlassian.confluence.search.contentnames.ContentNameSearchService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Path(value="/search")
public class QuickNavResource {
    private final ContentNameSearchService contentNameSearchService;
    private final HttpContext httpContext;
    private ConfluenceScopesRequestCache scopesRequestCacheDelegate;
    private final UserAccessor userAccessor;

    @Inject
    public QuickNavResource(@ComponentImport ContentNameSearchService contentNameSearchService, @ComponentImport HttpContext httpContext, @ComponentImport ConfluenceScopesRequestCache scopesRequestCacheDelegate, @ComponentImport UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
        this.contentNameSearchService = contentNameSearchService;
        this.httpContext = httpContext;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    @GET
    @Produces(value={"application/json"})
    @AnonymousSiteAccess
    @ScopesAllowed(requiredScope={"READ", "JSM_KB"})
    public Response getQuickNavResults(@QueryParam(value="query") String query, @QueryParam(value="type") List<String> types, @QueryParam(value="spaceKey") String spaceKey, @DefaultValue(value="false") @QueryParam(value="filterUnauthorizedSpaces") boolean filterUnauthorizedSpaces, @DefaultValue(value="-1") @QueryParam(value="maxPerCategory") int maxPerCategory, @DefaultValue(value="-1") @QueryParam(value="limit") int limit, @QueryParam(value="xoauth_requestor_id") String username) {
        if (this.scopesRequestCacheDelegate != null && this.scopesRequestCacheDelegate.isScopePermitted("JSM_KB") && username != null) {
            AuthenticatedUserThreadLocal.setUser((User)this.userAccessor.getUser(username));
        }
        ContentNameSearchContext contentNameSearchContext = new ContentNameSearchContext(types, spaceKey, maxPerCategory, this.httpContext.getRequest(), limit);
        SearchContext searchContext = SearchContext.getDefaultSearchContext();
        searchContext.setPermissionExempt(!filterUnauthorizedSpaces);
        contentNameSearchContext.setSearchContext(searchContext);
        ContentNameSearchResult result = this.contentNameSearchService.search(query, contentNameSearchContext);
        return Response.ok((Object)result).build();
    }
}

