/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.datetime.DateFormatterFactory;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeHistoryMacro
extends BaseMacro {
    private static final String TEMPLATE_NAME = "pages/includes/previous-versions-table.vm";
    public static final String SITE_WIDE_SHARED_DRAFTS_DARK_FEATURE = "site-wide.shared-drafts";
    private static final Logger logger = LoggerFactory.getLogger((String)ChangeHistoryMacro.class.getName());
    private final PageManager pageManager;
    private final DateFormatterFactory dateFormatterFactory;
    private final I18nResolver i18nResolver;
    private final DarkFeatureManager darkFeatureManager;
    private final VelocityHelperService velocityHelperService;

    public ChangeHistoryMacro(PageManager pageManager, DateFormatterFactory dateFormatterFactory, I18nResolver i18nResolver, DarkFeatureManager darkFeatureManager, VelocityHelperService velocityHelperService) {
        this.pageManager = pageManager;
        this.dateFormatterFactory = dateFormatterFactory;
        this.i18nResolver = i18nResolver;
        this.darkFeatureManager = darkFeatureManager;
        this.velocityHelperService = velocityHelperService;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Map<String, Object> contextMap = this.getDefaultVelocityContext();
        PageContext context = (PageContext)renderContext;
        ContentEntityObject ceo = context.getEntity();
        if (ceo instanceof AbstractPage) {
            AbstractPage page = (AbstractPage)ceo;
            List pageVersions = this.pageManager.getVersionHistorySummaries((ContentEntityObject)page);
            int limit = this.determineMacroLimit(parameters, page, pageVersions.size());
            List limitedVersions = pageVersions.subList(0, limit);
            contextMap.put("page", page);
            contextMap.put("allVersions", limitedVersions);
            contextMap.put("space", page.getSpace());
            contextMap.put("dateFormatter", this.dateFormatterFactory.createForUser());
            contextMap.put("offlineCollabEditingMode", this.isOfflineCollabEditingMode());
            contextMap.put("showFullPageHistoryLink", pageVersions.size() != limitedVersions.size());
            return this.getRenderedTemplate(contextMap);
        }
        return RenderUtils.blockError((String)this.i18nResolver.getText("changehistory.error.can-only-be-used-in-pages-or-blogposts"), (String)"");
    }

    private int determineMacroLimit(Map parameters, AbstractPage page, int totalVersions) {
        Integer limit = this.parseLimitParameter(parameters, page);
        if (limit == null || limit < 0) {
            return totalVersions;
        }
        return Math.min(totalVersions, limit);
    }

    private Integer parseLimitParameter(Map parameters, AbstractPage page) {
        try {
            return Optional.ofNullable(parameters.get("limit")).map(String.class::cast).filter(StringUtils::isNotBlank).map(Integer::parseInt).orElse(null);
        }
        catch (NumberFormatException e) {
            logger.warn("Error occurred during parsing 'limit' macro parameter on page {}: {}", (Object)page.getId(), (Object)e.getMessage());
            return null;
        }
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public boolean hasBody() {
        return false;
    }

    public boolean isInline() {
        return false;
    }

    private boolean isOfflineCollabEditingMode() {
        return this.darkFeatureManager.isEnabledForAllUsers(SITE_WIDE_SHARED_DRAFTS_DARK_FEATURE).orElse(false) == false;
    }

    protected String getRenderedTemplate(Map<String, Object> contextMap) {
        return this.velocityHelperService.getRenderedTemplate(TEMPLATE_NAME, contextMap);
    }

    protected Map<String, Object> getDefaultVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }
}

