/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.ContentEntityManagerInternal;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.plugins.macros.advanced.AbstractHtmlGeneratingMacro;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.radeox.macro.parameter.MacroParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentByUserMacro
extends AbstractHtmlGeneratingMacro {
    private static final Logger log = LoggerFactory.getLogger(ContentByUserMacro.class);
    private final String[] myParamDescription = new String[]{"1: user"};
    private final UserAccessor userAccessor;
    private final ContentEntityManagerInternal contentEntityManager;
    private final PermissionManager permissionManager;
    private final VelocityHelperService velocityHelperService;

    public ContentByUserMacro(UserAccessor userAccessor, ContentEntityManagerInternal contentEntityManager, PermissionManager permissionManager, VelocityHelperService velocityHelperService) {
        this.userAccessor = userAccessor;
        this.contentEntityManager = contentEntityManager;
        this.permissionManager = permissionManager;
        this.velocityHelperService = velocityHelperService;
    }

    public String getName() {
        return "content-by-user";
    }

    public String[] getParamDescription() {
        return this.myParamDescription;
    }

    @Override
    public String getHtml(MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        String username = StringUtils.defaultString((String)macroParameter.get("user", 0)).trim();
        Map contextMap = MacroUtils.defaultVelocityContext();
        ConfluenceUser user = this.fetchUser(username);
        List<ContentEntityObject> content = this.fetchContent(user);
        Collections.sort(content);
        contextMap.put("user", user);
        contextMap.put("content", content);
        try {
            return this.velocityHelperService.getRenderedTemplate("templates/macros/contentbyuser.vm", contextMap);
        }
        catch (Exception e) {
            log.error("Error while trying to assemble the ContentByUser result!", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    private ConfluenceUser fetchUser(String username) {
        return this.userAccessor.getUserByName(username);
    }

    private List<ContentEntityObject> fetchContent(ConfluenceUser user) {
        List result = this.contentEntityManager.getContentAuthoredByUser(user);
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        return this.permissionManager.getPermittedEntities(AuthenticatedUserThreadLocal.get(), Permission.VIEW, result);
    }
}

