/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.migration.LinkResolver;
import com.atlassian.confluence.content.render.xhtml.model.links.DefaultLink;
import com.atlassian.confluence.content.render.xhtml.model.links.NotPermittedLink;
import com.atlassian.confluence.content.render.xhtml.model.links.UnresolvedLink;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.BlogPostResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.CannotResolveResourceIdentifierException;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.PageResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifierResolver;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentTypeAware;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.macros.advanced.PageProvider;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.Link;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DefaultPageProvider
implements PageProvider {
    private final LinkResolver xhtmlMigrationLinkResolver;
    private final PermissionManager permissionManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final ResourceIdentifierResolver<BlogPostResourceIdentifier, BlogPost> blogPostResourceIdentifierResolver;
    private final ResourceIdentifierResolver<PageResourceIdentifier, Page> pageResourceIdentifierResolver;

    public DefaultPageProvider(LinkResolver xhtmlMigrationLinkResolver, PermissionManager permissionManager, I18NBeanFactory i18NBeanFactory, ResourceIdentifierResolver<BlogPostResourceIdentifier, BlogPost> blogPostResourceIdentifierResolver, ResourceIdentifierResolver<PageResourceIdentifier, Page> pageResourceIdentifierResolver) {
        this.xhtmlMigrationLinkResolver = xhtmlMigrationLinkResolver;
        this.permissionManager = permissionManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.blogPostResourceIdentifierResolver = blogPostResourceIdentifierResolver;
        this.pageResourceIdentifierResolver = pageResourceIdentifierResolver;
    }

    @Override
    public ContentEntityObject resolve(String location, ConversionContext context) throws NotAuthorizedException {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        if (StringUtils.isEmpty((CharSequence)location)) {
            throw new IllegalArgumentException(i18NBean.getText("confluence.macros.advanced.include.error.no.location"));
        }
        Link link = this.xhtmlMigrationLinkResolver.resolve(location, context.getPageContext());
        if (link == null) {
            throw new IllegalArgumentException(i18NBean.getText("confluence.macros.advanced.include.error.no.link", (Object[])new String[]{location}));
        }
        return this.resolve(link, context);
    }

    @Override
    public ContentEntityObject resolve(Link link, ConversionContext context) {
        ContentEntityObject currentPage = context.getEntity();
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        ResourceIdentifier resourceIdentifier = link.getDestinationResourceIdentifier();
        String location = this.getLocation(resourceIdentifier);
        if (link instanceof NotPermittedLink) {
            throw new NotAuthorizedException(i18NBean.getText("confluence.macros.advanced.include.error.user.not.authorized", (Object[])new String[]{AuthenticatedUserThreadLocal.getUsername()}));
        }
        if (link instanceof UnresolvedLink || !(link instanceof DefaultLink)) {
            return null;
        }
        if (this.linkingToSelf(link, context) && this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)currentPage)) {
            return currentPage;
        }
        AbstractPage page = this.resolveResourceIdentifier(resourceIdentifier, context);
        if (page == null) {
            throw new IllegalArgumentException(i18NBean.getText("confluence.macros.advanced.include.error.no.link", (Object[])new String[]{location}));
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page)) {
            throw new NotAuthorizedException(i18NBean.getText("confluence.macros.advanced.include.error.user.not.authorized", (Object[])new String[]{AuthenticatedUserThreadLocal.getUsername()}));
        }
        return page;
    }

    private boolean linkingToSelf(Link link, ConversionContext conversionContext) {
        if (conversionContext == null) {
            return true;
        }
        if (this.isGlobalObject(conversionContext)) {
            return false;
        }
        ResourceIdentifier resourceIdentifier = link.getDestinationResourceIdentifier();
        if (resourceIdentifier == null) {
            if (conversionContext.getProperty("macroDefinition") != null) {
                String linkedPageName = ((MacroDefinition)conversionContext.getProperty("macroDefinition")).getDefaultParameterValue();
                return this.isSamePageTitle(conversionContext, linkedPageName);
            }
            return true;
        }
        return this.isSameContentType(conversionContext, resourceIdentifier) && this.isSamePageTitle(conversionContext, resourceIdentifier) && this.isSameSpace(conversionContext, resourceIdentifier) && this.isSamePostingDateForBlog(conversionContext, resourceIdentifier);
    }

    private boolean isGlobalObject(ConversionContext conversionContext) {
        return conversionContext.getEntity() == null;
    }

    private boolean isSameContentType(ConversionContext conversionContext, ResourceIdentifier resourceIdentifier) {
        return ContentTypeEnum.PAGE.equals((Object)ContentTypeEnum.forEntity((ContentTypeAware)conversionContext.getEntity())) && resourceIdentifier instanceof PageResourceIdentifier || ContentTypeEnum.BLOG.equals((Object)ContentTypeEnum.forEntity((ContentTypeAware)conversionContext.getEntity())) && resourceIdentifier instanceof BlogPostResourceIdentifier;
    }

    private boolean isSamePageTitle(ConversionContext conversionContext, ResourceIdentifier resourceIdentifier) {
        return this.isSamePageTitle(conversionContext, this.getTitle(resourceIdentifier));
    }

    private boolean isSamePageTitle(ConversionContext conversionContext, String linkedPageTitle) {
        return StringUtils.isNotEmpty((CharSequence)conversionContext.getEntity().getTitle()) && conversionContext.getEntity().getTitle().equals(linkedPageTitle);
    }

    private boolean isSamePostingDateForBlog(ConversionContext conversionContext, ResourceIdentifier resourceIdentifier) {
        return !ContentTypeEnum.BLOG.equals((Object)ContentTypeEnum.forEntity((ContentTypeAware)conversionContext.getEntity())) || ((BlogPost)conversionContext.getEntity()).getPostingCalendarDate().equals(((BlogPostResourceIdentifier)resourceIdentifier).getPostingDay());
    }

    private String getTitle(ResourceIdentifier resourceIdentifier) {
        if (resourceIdentifier instanceof PageResourceIdentifier) {
            return ((PageResourceIdentifier)resourceIdentifier).getTitle();
        }
        if (resourceIdentifier instanceof BlogPostResourceIdentifier) {
            return ((BlogPostResourceIdentifier)resourceIdentifier).getTitle();
        }
        throw new IllegalArgumentException(this.i18NBeanFactory.getI18NBean().getText("confluence.macros.advanced.include.error.invalid.content-entity"));
    }

    private boolean isSameSpace(ConversionContext conversionContext, ResourceIdentifier resourceIdentifier) {
        return resourceIdentifier instanceof PageResourceIdentifier && ((PageResourceIdentifier)resourceIdentifier).getSpaceKey().equals(conversionContext.getSpaceKey()) || resourceIdentifier instanceof BlogPostResourceIdentifier && ((BlogPostResourceIdentifier)resourceIdentifier).getSpaceKey().equals(conversionContext.getSpaceKey());
    }

    private String getLocation(ResourceIdentifier resourceIdentifier) {
        if (resourceIdentifier instanceof BlogPostResourceIdentifier) {
            BlogPostResourceIdentifier blog = (BlogPostResourceIdentifier)resourceIdentifier;
            return (String)(blog.getSpaceKey() != null ? blog.getSpaceKey() + ":" : "") + "/" + BlogPost.toDatePath((Date)blog.getPostingDay().getTime()) + "/" + blog.getTitle();
        }
        if (resourceIdentifier instanceof PageResourceIdentifier) {
            PageResourceIdentifier page = (PageResourceIdentifier)resourceIdentifier;
            return (String)(page.getSpaceKey() != null ? page.getSpaceKey() + ":" : "") + page.getTitle();
        }
        return resourceIdentifier == null ? "" : resourceIdentifier.toString();
    }

    private AbstractPage resolveResourceIdentifier(ResourceIdentifier destination, ConversionContext context) {
        if (!(destination instanceof PageResourceIdentifier) && !(destination instanceof BlogPostResourceIdentifier)) {
            throw new IllegalArgumentException(this.i18NBeanFactory.getI18NBean().getText("confluence.macros.advanced.include.error.invalid.content-entity"));
        }
        try {
            if (destination instanceof BlogPostResourceIdentifier) {
                return (AbstractPage)this.blogPostResourceIdentifierResolver.resolve((ResourceIdentifier)((BlogPostResourceIdentifier)destination), context);
            }
            return (AbstractPage)this.pageResourceIdentifierResolver.resolve((ResourceIdentifier)((PageResourceIdentifier)destination), context);
        }
        catch (CannotResolveResourceIdentifierException e) {
            return null;
        }
    }
}

