/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

final class ExcerptUtil {
    private static final List<String> SINGLE_TAGS = List.of("br", "p", "hr");

    private ExcerptUtil() {
    }

    static String trimToEndingChar(String str, int len) {
        boolean inTag = false;
        boolean anyTags = false;
        StringBuilder result = new StringBuilder();
        int goodChars = 0;
        int lastEndingCharPos = -1;
        if (str.length() < len) {
            return str;
        }
        char[] strA = str.toCharArray();
        for (int i = 0; i < strA.length; ++i) {
            if (strA[i] == '<' && !inTag) {
                anyTags = true;
                inTag = true;
            }
            if (strA[i] == '>' && inTag) {
                inTag = false;
            }
            if (!inTag) {
                if (ExcerptUtil.isEndingChar(strA[i])) {
                    lastEndingCharPos = i;
                }
                ++goodChars;
            }
            result.append(strA[i]);
            if (goodChars == len) break;
        }
        if (lastEndingCharPos + 1 != result.length()) {
            if (lastEndingCharPos != -1) {
                result = new StringBuilder(result.substring(0, lastEndingCharPos + 1));
            } else {
                int spacePos = result.toString().lastIndexOf(32);
                if (spacePos != -1) {
                    result = new StringBuilder(result.substring(0, spacePos));
                }
            }
        }
        if (anyTags) {
            return ExcerptUtil.closeTags(result.toString());
        }
        return result.toString();
    }

    private static String closeTags(String str) {
        char[] strA;
        HashMap<Object, Integer> openTags = new HashMap<Object, Integer>();
        if (str == null) {
            str = "";
        }
        boolean inTag = false;
        boolean inTagName = false;
        boolean inOpenTag = true;
        Object tagName = "";
        for (char c : strA = str.toCharArray()) {
            if (!inTag) {
                if (c != '<') continue;
                inTag = true;
                inTagName = true;
                inOpenTag = true;
                tagName = "";
                continue;
            }
            if (((String)tagName).isEmpty() && c == '/') {
                inOpenTag = false;
                continue;
            }
            if (inTagName && (c == ' ' || c == '>' || c == '/')) {
                inTagName = false;
                if (inOpenTag && !SINGLE_TAGS.contains(((String)tagName).toLowerCase())) {
                    openTags.put(tagName, openTags.getOrDefault(tagName, 0) + 1);
                } else {
                    Integer tagCount = (Integer)openTags.get(tagName);
                    if (tagCount != null) {
                        if (tagCount > 1) {
                            openTags.put(tagName, tagCount - 1);
                        } else {
                            openTags.remove(tagName);
                        }
                    }
                }
                if (c != '>') continue;
                inTag = false;
                continue;
            }
            if (inTagName) {
                tagName = (String)tagName + c;
                continue;
            }
            if (c != '>') continue;
            inTag = false;
        }
        Iterator openTagNames = openTags.keySet().iterator();
        StringBuilder closedString = new StringBuilder(str);
        while (openTagNames.hasNext()) {
            String openTagName = (String)openTagNames.next();
            for (int i = 0; i < (Integer)openTags.get(openTagName); ++i) {
                closedString.append("</").append(openTagName).append('>');
            }
        }
        return closedString.toString();
    }

    private static boolean isEndingChar(char c) {
        return c == '.' || c == '!' || c == ',' || c == '?';
    }
}

