/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced;

import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PartialList;
import com.atlassian.confluence.dmz.labels.LabelManagerInternal;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class FavouritePagesMacro
extends BaseMacro {
    private static final String TEMPLATE_NAME = "com/atlassian/confluence/plugins/macros/advanced/favpages.vm";
    private final LabelManagerInternal labelManager;
    private final PermissionManager permissionManager;
    private final VelocityHelperService velocityHelperService;
    private final PaginationService paginationService;

    public FavouritePagesMacro(LabelManagerInternal labelManager, PermissionManager permissionManager, VelocityHelperService velocityHelperService, PaginationService paginationService) {
        this.labelManager = labelManager;
        this.permissionManager = permissionManager;
        this.velocityHelperService = velocityHelperService;
        this.paginationService = paginationService;
    }

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Map<String, Object> contextMap = this.getDefaultVelocityContext();
        int maxResults = 5;
        try {
            maxResults = Integer.parseInt((String)parameters.get("maxResults"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        contextMap.put("maxResults", maxResults);
        LimitedRequest limitedRequestFavourite = LimitedRequestImpl.create((int)0, (int)maxResults, (int)maxResults);
        LinkedList<ContentEntityObject> contentList = new LinkedList<ContentEntityObject>(this.getContentEntityObjectsForLabel("my:favourite", limitedRequestFavourite));
        if (contentList.size() < maxResults) {
            int remainingMaxResults = maxResults - contentList.size();
            LimitedRequest limitedRequestFavorite = LimitedRequestImpl.create((int)0, (int)remainingMaxResults, (int)remainingMaxResults);
            contentList.addAll(this.getContentEntityObjectsForLabel("my:favorite", limitedRequestFavorite));
        }
        contextMap.put("contents", contentList);
        return this.getRenderedTemplate(contextMap);
    }

    private List<ContentEntityObject> getContentEntityObjectsForLabel(String labelName, LimitedRequest limitedRequest) {
        PageResponse contentList = this.paginationService.performPaginationListRequest(limitedRequest, input -> {
            PageResponse<ContentEntityObject> result = this.fetchContentForLabelCollection(labelName, (LimitedRequest)input);
            List fetchedContents = this.filterByContentType(result.getResults(), Arrays.asList("page", "blogpost"));
            fetchedContents = this.permissionManager.getPermittedEntities(AuthenticatedUserThreadLocal.get(), Permission.VIEW, fetchedContents);
            return PageResponseImpl.builder().addAll((Iterable)fetchedContents).hasMore(result.hasMore()).pageRequest(limitedRequest).build();
        }, Function.identity());
        return contentList.getResults();
    }

    private PageResponse<ContentEntityObject> fetchContentForLabelCollection(String labelName, LimitedRequest input) {
        Label label;
        ParsedLabelName ref = this.parseLabel(labelName);
        if (ref != null && (label = this.labelManager.getLabel(ref)) != null) {
            PartialList partialResults = this.labelManager.getContentForLabel(input.getStart(), input.getMaxLimit(), label);
            return PageResponseImpl.builder().addAll((Iterable)partialResults.getList()).hasMore(partialResults.getAvailable() > input.getStart() + partialResults.getCount()).totalCount(Optional.of(Long.valueOf(partialResults.getAvailable()))).pageRequest(input).build();
        }
        return PageResponseImpl.builder().addAll(new LinkedList()).hasMore(false).pageRequest(input).build();
    }

    protected ParsedLabelName parseLabel(String labelName) {
        return LabelParser.parse((String)labelName, (User)AuthenticatedUserThreadLocal.get());
    }

    private List<ContentEntityObject> filterByContentType(List<ContentEntityObject> original, List<String> types) {
        ArrayList<ContentEntityObject> result = new ArrayList<ContentEntityObject>();
        for (ContentEntityObject contentEntityObject : original) {
            if (!types.contains(contentEntityObject.getType())) continue;
            result.add(contentEntityObject);
        }
        return result;
    }

    protected String getRenderedTemplate(Map<String, Object> contextMap) {
        return this.velocityHelperService.getRenderedTemplate(TEMPLATE_NAME, contextMap);
    }

    protected Map<String, Object> getDefaultVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }
}

