/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced;

import com.atlassian.confluence.content.ContentEntityExcerpter;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.plugins.macros.advanced.AbstractHtmlGeneratingMacro;
import com.atlassian.confluence.plugins.macros.advanced.BulkPermissionHelper;
import com.atlassian.confluence.plugins.macros.advanced.analytics.IndexMacroMetrics;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.denormalisedpermissions.BulkPermissionService;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.DocumentationBean;
import com.atlassian.confluence.util.i18n.DocumentationBeanFactory;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.time.StopWatch;
import org.radeox.macro.parameter.MacroParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexMacro
extends AbstractHtmlGeneratingMacro {
    public static final String DOC_LINK = "help.page.index.macro";
    @VisibleForTesting
    static final int EXCERPT_RENDER_LIMIT = Integer.getInteger("page.index.macro.excerpt-limit", 200);
    @VisibleForTesting
    static final int INDEX_RENDER_LIMIT = 1000;
    private static final int MAX_PAGES_TO_RENDER = Integer.getInteger("page.index.macro.max.pages", 1000);
    @VisibleForTesting
    static final int MAX_PAGES_TO_RENDER_FOR_BULK_PERMISSIONS_ENABLED = Integer.getInteger("page.index.macro.max.pages.bulk.permissions", 10000);
    @VisibleForTesting
    static final String TEMPLATE = "com/atlassian/confluence/plugins/macros/advanced/alphaindex.vm";
    @VisibleForTesting
    static final String TEMPLATE_ERROR = "com/atlassian/confluence/plugins/macros/advanced/alphaindexerror.vm";
    private static final Logger log = LoggerFactory.getLogger(IndexMacro.class);
    private static final String MACRO_NAME = "index";
    private final String[] myParamDescription = new String[]{"1: ignored"};
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final PageManager pageManager;
    private final GlobalSettingsManager settingsManager;
    private final HttpContext httpContext;
    private final DocumentationBeanFactory documentationBeanFactory;
    private final EventPublisher eventPublisher;
    private final BulkPermissionHelper bulkPermissionHelper;
    private final BulkPermissionService bulkPermissionService;
    private final VelocityHelperService velocityHelperService;

    public String getName() {
        return MACRO_NAME;
    }

    public IndexMacro(SpaceManager spaceManager, PermissionManager permissionManager, PageManager pageManager, GlobalSettingsManager settingsManager, DocumentationBeanFactory documentationBeanFactory, EventPublisher eventPublisher, BulkPermissionHelper bulkPermissionHelper, HttpContext httpContext, BulkPermissionService bulkPermissionService, VelocityHelperService velocityHelperService) {
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.settingsManager = settingsManager;
        this.documentationBeanFactory = documentationBeanFactory;
        this.eventPublisher = eventPublisher;
        this.bulkPermissionHelper = bulkPermissionHelper;
        this.httpContext = httpContext;
        this.bulkPermissionService = bulkPermissionService;
        this.velocityHelperService = velocityHelperService;
    }

    public String[] getParamDescription() {
        return this.myParamDescription;
    }

    @Override
    public String getHtml(MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        StopWatch watch = StopWatch.createStarted();
        Map<String, Object> contextMap = this.getDefaultVelocityContext();
        Map contextParams = macroParameter.getContext().getParameters();
        String currentSpaceKey = ((PageContext)contextParams.get("RENDER_CONTEXT")).getSpaceKey();
        Space currentSpace = this.spaceManager.getSpace(currentSpaceKey);
        contextMap.put("isBulkPermissionsUpAndRunning", this.bulkPermissionHelper.isBulkPermissionsUpAndRunning());
        contextMap.put("shouldCallBulkPermissionsAPI", this.bulkPermissionHelper.shouldCallBulkPermissionsAPI());
        long totalPages = this.pageManager.getPageCount(currentSpace.getKey());
        contextMap.put("baseurl", this.calculateBaseUrl());
        contextMap.put("printDebugInformation", this.bulkPermissionHelper.shouldPrintDebugInformation());
        contextMap.put("thisMacro", (Object)this);
        contextMap.put("excerptRenderLimit", EXCERPT_RENDER_LIMIT);
        boolean permissionsExempt = this.bulkPermissionHelper.isPermissionExempt((User)AuthenticatedUserThreadLocal.get());
        if (this.bulkPermissionHelper.shouldCallBulkPermissionsAPI()) {
            contextMap.put("totalPages", totalPages);
            contextMap.put("maxPages", MAX_PAGES_TO_RENDER_FOR_BULK_PERMISSIONS_ENABLED);
            if (totalPages > (long)MAX_PAGES_TO_RENDER_FOR_BULK_PERMISSIONS_ENABLED) {
                contextMap.put("docUrl", this.getDocBean().getLink(DOC_LINK));
                IndexMacroMetrics metrics = new IndexMacroMetrics(permissionsExempt, 0, watch.getDuration().toMillis(), false, this.bulkPermissionHelper.isBulkPermissionsUpAndRunning(), MAX_PAGES_TO_RENDER_FOR_BULK_PERMISSIONS_ENABLED, true);
                this.eventPublisher.publish((Object)metrics);
                return this.getVelocityRenderedTemplate(TEMPLATE_ERROR, contextMap);
            }
            pages = this.fetchPagesFromBulkPermissionService(currentSpace);
            contextMap.put("totalVisiblePages", pages.size());
            contextMap.put("pages", new AlphabeticPageListing(pages));
            contextMap.put("totalPages", pages.size());
            contextMap.put("duration", watch.getDuration().toMillis());
            IndexMacroMetrics metrics = new IndexMacroMetrics(permissionsExempt, pages.size(), watch.getDuration().toMillis(), true, this.bulkPermissionHelper.isBulkPermissionsUpAndRunning(), 0, false);
            this.eventPublisher.publish((Object)metrics);
        } else {
            contextMap.put("totalPages", totalPages);
            contextMap.put("maxPages", MAX_PAGES_TO_RENDER);
            if (totalPages > (long)MAX_PAGES_TO_RENDER) {
                contextMap.put("docUrl", this.getDocBean().getLink(DOC_LINK));
                IndexMacroMetrics metrics = new IndexMacroMetrics(permissionsExempt, 0, watch.getDuration().toMillis(), false, false, MAX_PAGES_TO_RENDER, true);
                this.eventPublisher.publish((Object)metrics);
                return this.getVelocityRenderedTemplate(TEMPLATE_ERROR, contextMap);
            }
            pages = this.fetchPages(currentSpace);
            contextMap.put("totalVisiblePages", pages.size());
            contextMap.put("pages", new AlphabeticPageListing(pages));
            contextMap.put("duration", watch.getDuration().toMillis());
            IndexMacroMetrics metrics = new IndexMacroMetrics(permissionsExempt, pages.size(), watch.getDuration().toMillis(), false, false, MAX_PAGES_TO_RENDER, false);
            this.eventPublisher.publish((Object)metrics);
        }
        try {
            return this.getVelocityRenderedTemplate(TEMPLATE, contextMap);
        }
        catch (Exception e) {
            log.error("Error while trying to assemble the IndexMacro result!", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    protected Map<String, Object> getDefaultVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }

    @VisibleForTesting
    protected String getVelocityRenderedTemplate(String templateName, Map<String, Object> contextMap) {
        return this.velocityHelperService.getRenderedTemplate(templateName, contextMap);
    }

    @HtmlSafe
    public String getHtmlSafeExcerpt(Page page) {
        return HtmlUtil.htmlEncode((String)new ContentEntityExcerpter().createExcerpt((ContentEntityObject)page).orElse(null));
    }

    private List<Page> fetchPages(Space currentSpace) {
        List pagesWithPermissions = this.pageManager.getPagesWithPermissions(currentSpace);
        return this.permissionManager.getPermittedEntities(AuthenticatedUserThreadLocal.get(), Permission.VIEW, pagesWithPermissions);
    }

    private List<Page> fetchPagesFromBulkPermissionService(Space space) {
        List allPages = this.bulkPermissionService.getAllVisiblePagesInSpace(AuthenticatedUserThreadLocal.get(), space.getId());
        return BulkPermissionHelper.fromSimpleContentList(allPages, space);
    }

    public DocumentationBean getDocBean() {
        return this.documentationBeanFactory.getDocumentationBean();
    }

    private String calculateBaseUrl() {
        HttpServletRequest request = this.httpContext.getActiveRequest();
        return request != null ? request.getContextPath() : this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    public static class AlphabeticPageListing {
        private static final String[] keys = new String[]{"0-9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "!@#$"};
        private final Map<String, TreeSet<Page>> pageMap;
        private final List<String> keyList = Arrays.asList(keys);

        public AlphabeticPageListing(List<Page> pages) {
            this.pageMap = new HashMap<String, TreeSet<Page>>();
            for (Page page : pages) {
                char c = Character.toUpperCase(page.getTitle().charAt(0));
                if (Character.isDigit(c)) {
                    this.addToMap("0-9", page);
                    continue;
                }
                if (c >= 'A' && c <= 'Z') {
                    this.addToMap(Character.toString(c), page);
                    continue;
                }
                this.addToMap("@", page);
            }
        }

        public List<String> getKeys() {
            return this.keyList;
        }

        public int getPageCount(String key) {
            if (!this.pageMap.containsKey(key)) {
                return 0;
            }
            return this.pageMap.get(key).size();
        }

        public Set getPages(String key) {
            if (!this.pageMap.containsKey(key)) {
                return new TreeSet();
            }
            return this.pageMap.get(key);
        }

        private void addToMap(String key, Page page) {
            if (!this.pageMap.containsKey(key)) {
                this.pageMap.put(key, new TreeSet());
            }
            this.pageMap.get(key).add(page);
        }
    }
}

