/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced;

import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.dmz.labels.LabelManagerInternal;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelPermissionEnforcer;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.actions.AlphabeticalLabelGroupingSupport;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ListLabelsMacro
extends BaseMacro
implements Macro {
    private static final String TOKEN_ALL = "@all";
    public static final String PARAM_COUNT = "count";
    public static final String PARAM_SPACEKEY = "spaceKey";
    public static final String PARAM_EXCLUDEDLABELS = "excludedLabels";
    private static final int DEFAULT_PAGE_START = 0;
    private static final int DEFAULT_COUNT = 100;
    private static final int MAX_LISTLABELS_LABELS_TO_PROCESS_DEFAULT = 1000000;
    private static final String MAX_LISTLABELS_LABELS_TO_PROCESS_KEY = "confluence.macros.advanced.listlabels.labels.max.to.process";
    private final LabelManagerInternal labelManager;
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final VelocityHelperService velocityHelperService;
    private final PaginationService paginationService;
    private final LabelPermissionEnforcer labelPermissionEnforcer;

    public ListLabelsMacro(LabelManagerInternal labelManager, SpaceManager spaceManager, PermissionManager permissionManager, I18NBeanFactory i18NBeanFactory, VelocityHelperService velocityHelperService, PaginationService paginationService, LabelPermissionEnforcer labelPermissionEnforcer) {
        this.labelManager = labelManager;
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.velocityHelperService = velocityHelperService;
        this.paginationService = paginationService;
        this.labelPermissionEnforcer = labelPermissionEnforcer;
    }

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map parameters, String body, ConversionContext conversionContext) {
        try {
            return this.execute(parameters, body, (RenderContext)conversionContext.getPageContext());
        }
        catch (MacroException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Space space;
        String spaceKey = (String)parameters.get(PARAM_SPACEKEY);
        String excludedLabelsParam = (String)parameters.get(PARAM_EXCLUDEDLABELS);
        int numLabelsToDisplay = this.calculateLimit(parameters, 100);
        int maxLabelsToProcess = this.getMaxLabelsToProcess();
        Object[] excludedLabels = null;
        if (!StringUtils.isBlank((CharSequence)excludedLabelsParam)) {
            excludedLabels = excludedLabelsParam.trim().split("\\s*,\\s*");
            Arrays.sort(excludedLabels);
        }
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            PageContext pCtx = (PageContext)renderContext;
            spaceKey = pCtx.getSpaceKey();
        }
        if ((space = this.spaceManager.getSpace(spaceKey)) != null && !this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)space)) {
            throw new NotAuthorizedException(this.i18NBeanFactory.getI18NBean().getText("confluence.macros.advanced.listlabels.error.user.not.authorized", (Object[])new String[]{AuthenticatedUserThreadLocal.get() == null ? this.i18NBeanFactory.getI18NBean().getText("anonymous.name") : AuthenticatedUserThreadLocal.getUsername()}));
        }
        AlphabeticalLabelGroupingSupport<Label> alphaSupport = this.getAlphaSupport(spaceKey, (String[])excludedLabels, numLabelsToDisplay, maxLabelsToProcess);
        Map<String, Object> contextMap = this.getDefaultVelocityContext();
        contextMap.put("alphaSupport", alphaSupport);
        contextMap.put("space", this.spaceManager.getSpace(spaceKey));
        contextMap.put(PARAM_SPACEKEY, spaceKey);
        return this.getRenderedTemplate(contextMap);
    }

    public AlphabeticalLabelGroupingSupport<Label> getAlphaSupport(@Nonnull String spaceKey, @Nullable String[] sortedExcludedLabels, int numLabelsToDisplay, int maxLabelsToProcess) {
        Collection<Object> labels;
        SimplePageRequest pageRequest = new SimplePageRequest(0, numLabelsToDisplay);
        if (TOKEN_ALL.equals(spaceKey)) {
            TreeSet<Label> labelsSet = new TreeSet<Label>();
            List spaces = this.spaceManager.getAllSpaces();
            for (Space space : spaces) {
                labelsSet.addAll(this.fetchAuthorizedLabels(space.getKey(), (PageRequest)pageRequest, maxLabelsToProcess));
                if (numLabelsToDisplay - labelsSet.size() <= 0) break;
                pageRequest = new SimplePageRequest(0, numLabelsToDisplay - labelsSet.size());
            }
            labels = new ArrayList<Label>(labelsSet);
        } else {
            labels = this.fetchAuthorizedLabels(spaceKey, (PageRequest)pageRequest, maxLabelsToProcess);
        }
        if (!ArrayUtils.isEmpty((Object[])sortedExcludedLabels)) {
            labels = labels.stream().filter(input -> input != null && Arrays.binarySearch(sortedExcludedLabels, input.toString()) < 0).collect(Collectors.toList());
        }
        return new AlphabeticalLabelGroupingSupport(labels);
    }

    private List<Label> fetchAuthorizedLabels(String spaceKey, PageRequest pageRequest, int maxLabelsToProcess) {
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)maxLabelsToProcess);
        PageResponse labels = this.paginationService.performPaginationListRequest(limitedRequest, input -> {
            PageResponse result = this.labelManager.getLabelsInSpace(spaceKey, input);
            return this.fetchFilteredLabelsPageResponse(pageRequest, (LimitedRequest)input, (PageResponse<Label>)result, maxLabelsToProcess);
        }, Function.identity());
        return labels.getResults();
    }

    private PageResponse<Label> fetchFilteredLabelsPageResponse(PageRequest pageRequest, LimitedRequest input, PageResponse<Label> result, int maxLabelsToProcess) {
        List authorizedLabels = this.labelPermissionEnforcer.filterAuthorizedLabels(result.getResults());
        return PageResponseImpl.builder().addAll((Iterable)authorizedLabels).hasMore(input.getStart() + input.getLimit() < maxLabelsToProcess && result.hasMore()).pageRequest(pageRequest).build();
    }

    private int getMaxLabelsToProcess() {
        return (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{Integer.getInteger(MAX_LISTLABELS_LABELS_TO_PROCESS_KEY), 1000000});
    }

    private int calculateLimit(Map parameters, int defaultValue) {
        try {
            int maxResults = Integer.parseInt((String)parameters.get(PARAM_COUNT));
            return maxResults <= 0 ? defaultValue : maxResults;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    protected String getRenderedTemplate(Map<String, Object> contextMap) {
        return this.velocityHelperService.getRenderedTemplate("/com/atlassian/confluence/plugins/macros/advanced/listlabelsmacro.vm", contextMap);
    }

    protected Map<String, Object> getDefaultVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }
}

