/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.macros.advanced.PageProvider;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.renderer.RenderContext;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
public class PageIncludeServlet
extends HttpServlet {
    private final PageProvider pageProvider;
    private final PageManager pageManager;
    private final I18NBeanFactory i18NBeanFactory;

    public PageIncludeServlet(PageProvider pageProvider, PageManager pageManager, I18NBeanFactory i18NBeanFactory) {
        this.pageProvider = pageProvider;
        this.pageManager = pageManager;
        this.i18NBeanFactory = i18NBeanFactory;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long contentId;
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        String location = req.getParameter("location");
        if (StringUtils.isBlank((CharSequence)location)) {
            resp.sendError(400, i18NBean.getText("confluence.macros.advanced.include.error.no.location"));
            return;
        }
        try {
            contentId = Long.parseLong(req.getParameter("contentId"));
        }
        catch (IllegalArgumentException e) {
            resp.sendError(400, i18NBean.getText("confluence.macros.advanced.include.error.invalid.content-id"));
            return;
        }
        ContentEntityObject ceo = this.pageManager.getById(contentId);
        if (ceo == null) {
            resp.sendError(400, i18NBean.getText("confluence.macros.advanced.include.error.no.content-entity"));
            return;
        }
        try {
            PageContext context = new PageContext(ceo);
            DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)context);
            ContentEntityObject page = this.pageProvider.resolve(location, (ConversionContext)conversionContext);
            if (page == null) {
                resp.sendError(404);
                return;
            }
            String baseUrl = RequestCacheThreadLocal.getContextPath();
            resp.sendRedirect(baseUrl + page.getUrlPath());
        }
        catch (IllegalArgumentException e) {
            resp.sendError(404, e.getMessage());
        }
        catch (NotAuthorizedException e) {
            resp.sendError(404, i18NBean.getText("confluence.macros.advanced.include.error.content.not.found"));
        }
    }
}

