/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced;

import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.dmz.labels.LabelManagerInternal;
import com.atlassian.confluence.labels.LabelPermissionEnforcer;
import com.atlassian.confluence.labels.actions.RankedNameComparator;
import com.atlassian.confluence.labels.actions.RankedRankComparator;
import com.atlassian.confluence.labels.dto.LiteLabelSearchResult;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.plugins.macros.advanced.label.RankedRankLiteComparator;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PopularLabelsMacro
extends BaseMacro {
    private static final String TEMPLATE_NAME = "com/atlassian/confluence/plugins/macros/advanced/popularlabels.vm";
    private static final String TEMPLATE_NAME_FOR_LITE_LABELS = "com/atlassian/confluence/plugins/macros/advanced/popular-lite-labels.vm";
    private static final int DEFAULT_COUNT = 100;
    private static final int DEFAULT_PAGE_START = 0;
    private final int MAX_POPULAR_LABELS_TO_PROCESS = Integer.getInteger("confluence.macros.advanced.popular.labels.max.to.process", 1000000);
    private final LabelManagerInternal labelManager;
    private final GlobalSettingsManager settingsManager;
    private final VelocityHelperService velocityHelperService;
    private final HttpContext httpContext;
    private final PaginationService paginationService;
    private final LabelPermissionEnforcer labelPermissionEnforcer;
    private final boolean DISABLE_POPULAR_MACRO_CACHE = Boolean.getBoolean("confluence.popular-label-macro.disable-cache");

    public PopularLabelsMacro(LabelManagerInternal labelManager, VelocityHelperService velocityHelperService, GlobalSettingsManager settingsManager, HttpContext httpContext, PaginationService paginationService, LabelPermissionEnforcer labelPermissionEnforcer) {
        this.labelManager = labelManager;
        this.velocityHelperService = velocityHelperService;
        this.settingsManager = settingsManager;
        this.httpContext = httpContext;
        this.paginationService = paginationService;
        this.labelPermissionEnforcer = labelPermissionEnforcer;
    }

    public TokenType getTokenType(Map parameters, String body, RenderContext context) {
        return TokenType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Map contextMap = this.velocityHelperService.createDefaultVelocityContext();
        String spaceKey = (String)parameters.get("spaceKey");
        if (StringUtils.isNotEmpty((CharSequence)spaceKey)) {
            contextMap.put("spaceKey", spaceKey);
        }
        String style = (String)parameters.get("style");
        contextMap.put("style", style);
        int maxResults = this.calculateLimit(parameters, 100);
        SimplePageRequest pageRequest = new SimplePageRequest(0, maxResults);
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)this.MAX_POPULAR_LABELS_TO_PROCESS);
        if (this.DISABLE_POPULAR_MACRO_CACHE) {
            RankedNameComparator labelsComparator = StringUtils.equals((CharSequence)"heatmap", (CharSequence)style) ? new RankedNameComparator() : new RankedRankComparator();
            List labels = this.paginationService.performPaginationListRequest(limitedRequest, arg_0 -> this.lambda$execute$0(spaceKey, (PageRequest)pageRequest, arg_0), Function.identity()).getResults();
            Set rankedLabels = this.labelManager.getRankedLabels(labels, (Comparator)labelsComparator);
            contextMap.put("labels", rankedLabels);
            return this.velocityHelperService.getRenderedTemplate(TEMPLATE_NAME, contextMap);
        }
        RankedRankLiteComparator labelsComparator = StringUtils.equals((CharSequence)"heatmap", (CharSequence)style) ? Comparator.comparing(LiteLabelSearchResult::getName) : new RankedRankLiteComparator();
        List liteLabels = this.paginationService.performPaginationListRequest(limitedRequest, arg_0 -> this.lambda$execute$1(spaceKey, (PageRequest)pageRequest, arg_0), Function.identity()).getResults();
        Set rankedLabels = this.labelManager.calculateRanksForLiteLabels(liteLabels, (Comparator)labelsComparator);
        String baseUrl = this.calculateBaseUrl();
        List simpleLinks = rankedLabels.stream().map(label -> new LabelLink(label.getName(), baseUrl + label.getUrlPath(spaceKey), label.getRank())).collect(Collectors.toList());
        contextMap.put("labels", simpleLinks);
        return this.velocityHelperService.getRenderedTemplate(TEMPLATE_NAME_FOR_LITE_LABELS, contextMap);
    }

    private PageResponse<LabelSearchResult> fetchFilteredLabelSearchResultsPageResponse(PageRequest pageRequest, LimitedRequest paginationRequest, PageResponse<LabelSearchResult> result) {
        List<LabelSearchResult> authorizedLabels = result.getResults().stream().filter(labelSearchResult -> this.labelPermissionEnforcer.userCanViewLabel(labelSearchResult.getLabel())).toList();
        return PageResponseImpl.builder().addAll(authorizedLabels).hasMore(paginationRequest.getStart() + paginationRequest.getLimit() < this.MAX_POPULAR_LABELS_TO_PROCESS && result.hasMore()).pageRequest(pageRequest).build();
    }

    private PageResponse<LiteLabelSearchResult> fetchFilteredLiteLabelsPageResponse(PageRequest pageRequest, LimitedRequest paginationRequest, PageResponse<LiteLabelSearchResult> result) {
        List<LiteLabelSearchResult> authorizedLabels = result.getResults().stream().filter(liteLabelSearchResult -> this.labelPermissionEnforcer.userCanViewLabel(this.labelManager.getLabel(liteLabelSearchResult.getId()))).toList();
        return PageResponseImpl.builder().addAll(authorizedLabels).hasMore(paginationRequest.getStart() + paginationRequest.getLimit() < this.MAX_POPULAR_LABELS_TO_PROCESS && result.hasMore()).pageRequest(pageRequest).build();
    }

    private int calculateLimit(Map parameters, int defaultValue) {
        try {
            int maxResults = Integer.parseInt((String)parameters.get("count"));
            return maxResults <= 0 ? defaultValue : maxResults;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private String calculateBaseUrl() {
        HttpServletRequest request = this.httpContext.getActiveRequest();
        return request != null ? request.getContextPath() : this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    private /* synthetic */ PageResponse lambda$execute$1(String spaceKey, PageRequest pageRequest, LimitedRequest paginationRequest) {
        PageResponse result = StringUtils.isNotEmpty((CharSequence)spaceKey) ? this.labelManager.getMostPopularLabelsInSpaceLite(spaceKey.trim(), paginationRequest) : this.labelManager.getMostPopularLabelsInSiteLite(paginationRequest);
        return this.fetchFilteredLiteLabelsPageResponse(pageRequest, paginationRequest, (PageResponse<LiteLabelSearchResult>)result);
    }

    private /* synthetic */ PageResponse lambda$execute$0(String spaceKey, PageRequest pageRequest, LimitedRequest paginationRequest) {
        PageResponse result = StringUtils.isNotEmpty((CharSequence)spaceKey) ? this.labelManager.getMostPopularLabelsInSpace(spaceKey.trim(), paginationRequest) : this.labelManager.getMostPopularLabels(paginationRequest);
        return this.fetchFilteredLabelSearchResultsPageResponse(pageRequest, paginationRequest, (PageResponse<LabelSearchResult>)result);
    }

    public static class LabelLink {
        private final String name;
        private final String href;
        private final Integer rank;

        public LabelLink(String name, String href, Integer rank) {
            this.name = name;
            this.href = href;
            this.rank = rank;
        }

        public String getName() {
            return this.name;
        }

        public String getHref() {
            return this.href;
        }

        public Integer getRank() {
            return this.rank;
        }
    }
}

