/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced;

import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.dmz.labels.LabelManagerInternal;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelPermissionEnforcer;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.util.VelocityUtil;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class RecentlyUsedLabelsMacro
extends BaseMacro {
    private static final String TEMPLATE_NAME = "com/atlassian/confluence/plugins/macros/advanced/recentlyusedlabels";
    private static final String TABULAR_TEMPLATE_NAME = "com/atlassian/confluence/plugins/macros/advanced/recentlyusedlabels-tabular.vm";
    private static final String COMPACT_TEMPLATE_NAME = "com/atlassian/confluence/plugins/macros/advanced/recentlyusedlabels-compact.vm";
    private static final String STYLE = "style";
    private static final String COUNT = "count";
    private static final int DEFAULT_COUNT = 10;
    private static final String SCOPE = "scope";
    private static final String DEFAULT_SCOPE = "global";
    private static final String TITLE = "title";
    private static final int MAX_RESULTS = 100;
    private static final int DEFAULT_PAGE_START = 0;
    private final int MAX_RECENTLYUSED_LABELS_TO_PROCESS = Integer.getInteger("confluence.macros.advanced.recently.used.labels.max.to.process", 1000000);
    private final LabelManagerInternal labelManager;
    private final UserAccessor userAccessor;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;
    private final PermissionManager permissionManager;
    private final VelocityHelperService velocityHelperService;
    private final HttpContext httpContext;
    private final PaginationService paginationService;
    private final LabelPermissionEnforcer labelPermissionEnforcer;

    public RecentlyUsedLabelsMacro(LabelManagerInternal labelManager, UserAccessor userAccessor, HttpContext httpContext, FormatSettingsManager formatSettingsManager, LocaleManager localeManager, PermissionManager permissionManager, VelocityHelperService velocityHelperService, PaginationService paginationService, LabelPermissionEnforcer labelPermissionEnforcer) {
        this.labelManager = labelManager;
        this.userAccessor = userAccessor;
        this.httpContext = httpContext;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.permissionManager = permissionManager;
        this.velocityHelperService = velocityHelperService;
        this.paginationService = paginationService;
        this.labelPermissionEnforcer = labelPermissionEnforcer;
    }

    public String execute(Map parameters, String string, RenderContext renderContext) throws MacroException {
        String style;
        Map<String, Object> contextMap = this.getMacroVelocityContext();
        int maxResults = 10;
        if (parameters.containsKey(COUNT)) {
            maxResults = Integer.parseInt((String)parameters.get(COUNT));
        }
        maxResults = Math.min(maxResults, 100);
        SimplePageRequest pageRequest = new SimplePageRequest(0, maxResults);
        String scope = DEFAULT_SCOPE;
        if (StringUtils.isNotEmpty((CharSequence)((String)parameters.get(SCOPE)))) {
            scope = (String)parameters.get(SCOPE);
        }
        if (StringUtils.isNotEmpty((CharSequence)((String)parameters.get(TITLE)))) {
            String title = (String)parameters.get(TITLE);
            contextMap.put(TITLE, title);
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String spaceKey = ((PageContext)renderContext).getSpaceKey();
        String template = COMPACT_TEMPLATE_NAME;
        if (StringUtils.isNotEmpty((CharSequence)((String)parameters.get(STYLE))) && "table".equalsIgnoreCase(style = (String)parameters.get(STYLE))) {
            template = TABULAR_TEMPLATE_NAME;
        }
        if (TABULAR_TEMPLATE_NAME.equals(template)) {
            contextMap.put("recentlyUsedLabellings", this.getLabellings(spaceKey, scope, user, (PageRequest)pageRequest));
        } else {
            contextMap.put("recentlyUsedLabels", this.getLabels(spaceKey, scope, user, (PageRequest)pageRequest));
        }
        UserPreferences pref = this.userAccessor.getUserPreferences(user);
        DateFormatter df = new DateFormatter(pref.getTimeZone(), this.formatSettingsManager, this.localeManager);
        contextMap.put("dateFormatter", df);
        contextMap.put("spaceKey", spaceKey);
        contextMap.put("request", this.httpContext.getActiveRequest());
        contextMap.put("generalUtil", VelocityUtil.INSTANCE);
        return this.renderRecentlyUsedLabels(contextMap, template);
    }

    protected String renderRecentlyUsedLabels(Map<String, Object> contextMap, String template) {
        return this.velocityHelperService.getRenderedTemplate(template, contextMap);
    }

    protected Map<String, Object> getMacroVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }

    private List getLabels(String spaceKey, String scope, ConfluenceUser user, PageRequest pageRequest) {
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)this.MAX_RECENTLYUSED_LABELS_TO_PROCESS);
        Function<LimitedRequest, PageResponse> labelFetcher = scope.equalsIgnoreCase("space") ? paginationRequest -> this.labelManager.getRecentlyUsedLabelsInSpace(spaceKey, paginationRequest) : (scope.equalsIgnoreCase("personal") ? (user != null ? paginationRequest -> this.labelManager.getRecentlyUsedPersonalLabels(user.getName(), paginationRequest) : arg_0 -> ((LabelManagerInternal)this.labelManager).getRecentlyUsedLabels(arg_0)) : arg_0 -> ((LabelManagerInternal)this.labelManager).getRecentlyUsedLabels(arg_0));
        return this.paginationService.performPaginationListRequest(limitedRequest, paginationRequest -> {
            PageResponse result = (PageResponse)labelFetcher.apply((LimitedRequest)paginationRequest);
            return this.fetchFilteredLabelsPageResponse(pageRequest, (LimitedRequest)paginationRequest, (PageResponse<Label>)result);
        }, Function.identity()).getResults();
    }

    private PageResponse<Label> fetchFilteredLabelsPageResponse(PageRequest pageRequest, LimitedRequest paginationRequest, PageResponse<Label> result) {
        List authorizedLabels = this.labelPermissionEnforcer.filterAuthorizedLabels(result.getResults());
        return PageResponseImpl.builder().addAll((Iterable)authorizedLabels).hasMore(paginationRequest.getStart() + paginationRequest.getLimit() < this.MAX_RECENTLYUSED_LABELS_TO_PROCESS && result.hasMore()).pageRequest(pageRequest).build();
    }

    private List getLabellings(String spaceKey, String scope, ConfluenceUser user, PageRequest pageRequest) {
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)pageRequest, (int)this.MAX_RECENTLYUSED_LABELS_TO_PROCESS);
        Function<LimitedRequest, PageResponse> labellingFetcher = scope.equalsIgnoreCase("space") ? paginationRequest -> this.labelManager.getRecentlyUsedLabellingsInSpace(spaceKey, paginationRequest) : (scope.equalsIgnoreCase("personal") ? (user != null ? paginationRequest -> this.labelManager.getRecentlyUsedPersonalLabellings(user.getName(), paginationRequest) : arg_0 -> ((LabelManagerInternal)this.labelManager).getRecentlyUsedLabellings(arg_0)) : arg_0 -> ((LabelManagerInternal)this.labelManager).getRecentlyUsedLabellings(arg_0));
        return this.paginationService.performPaginationListRequest(limitedRequest, paginationRequest -> {
            PageResponse result = (PageResponse)labellingFetcher.apply((LimitedRequest)paginationRequest);
            return this.fetchFilteredLabellingsPageResponse(user, pageRequest, (LimitedRequest)paginationRequest, (PageResponse<Labelling>)result);
        }, Function.identity()).getResults();
    }

    private PageResponse<Labelling> fetchFilteredLabellingsPageResponse(ConfluenceUser user, PageRequest pageRequest, LimitedRequest paginationRequest, PageResponse<Labelling> result) {
        List authorizedLabellings = this.permissionManager.getPermittedEntities(user, Permission.VIEW, result.getResults());
        return PageResponseImpl.builder().addAll((Iterable)authorizedLabellings).hasMore(paginationRequest.getStart() + paginationRequest.getLimit() < this.MAX_RECENTLYUSED_LABELS_TO_PROCESS && result.hasMore()).pageRequest(pageRequest).build();
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public boolean hasBody() {
        return false;
    }
}

