/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.confluence.search.v2.query.NonViewableCustomContentTypeQuery;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SearchMacro
extends BaseMacro {
    private static final Logger log = LoggerFactory.getLogger(SearchMacro.class);
    private static final int DEFAULT_MAXLIMIT = 10;
    private final SearchManager searchManager;
    private final PredefinedSearchBuilder predefinedSearchBuilder;
    private final UserAccessor userAccessor;
    private final PluginAccessor pluginAccessor;
    private final I18NBeanFactory i18NBeanFactory;
    private final VelocityHelperService velocityHelperService;

    public SearchMacro(SearchManager searchManager, PredefinedSearchBuilder predefinedSearchBuilder, UserAccessor userAccessor, PluginAccessor pluginAccessor, I18NBeanFactory i18NBeanFactory, VelocityHelperService velocityHelperService) {
        this.searchManager = searchManager;
        this.predefinedSearchBuilder = predefinedSearchBuilder;
        this.userAccessor = userAccessor;
        this.pluginAccessor = pluginAccessor;
        this.i18NBeanFactory = i18NBeanFactory;
        this.velocityHelperService = velocityHelperService;
    }

    public TokenType getTokenType(Map parameters, String body, RenderContext context) {
        return TokenType.BLOCK;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map params, String string, RenderContext renderContext) throws MacroException {
        SearchResults searchResults;
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        if (!(renderContext instanceof PageContext)) {
            throw new ClassCastException(i18NBean.getText("search.error.macro-works-in-only-confluence", (Object[])new String[]{renderContext.getClass().getName(), PageContext.class.getName()}));
        }
        Object queryString = StringUtils.trimToNull((String)((String)params.get("query")));
        String userEnteredQuery = queryString;
        if (queryString == null) {
            queryString = StringUtils.trimToNull((String)((String)params.get("0")));
        }
        if (!StringUtils.isEmpty((CharSequence)queryString) && ((PageContext)renderContext).getEntity() != null) {
            queryString = "(" + (String)queryString + ") AND NOT handle: " + String.valueOf(new HibernateHandle((Searchable)((PageContext)renderContext).getEntity()));
            log.info("Instrumenting query to become: {}", queryString);
        }
        SearchQueryParameters searchQueryParams = new SearchQueryParameters((String)queryString);
        Integer maxLimit = SearchMacro.convertToInteger(params.get("maxLimit"));
        if (maxLimit == null) {
            maxLimit = 10;
        }
        String spaceKey = StringUtils.trimToNull((String)((String)params.get("spacekey")));
        String type = StringUtils.trimToNull((String)((String)params.get("type")));
        String lastModified = StringUtils.trimToNull((String)((String)params.get("lastModified")));
        String contributor = StringUtils.trimToNull((String)((String)params.get("contributor")));
        searchQueryParams.setSpaceKey(spaceKey);
        if (StringUtils.isNotBlank((CharSequence)type)) {
            ContentTypeEnum contentType = ContentTypeEnum.getByRepresentation((String)type);
            if (contentType == null) {
                throw new MacroException(i18NBean.getText("search.error.unknown-content-type"));
            }
            searchQueryParams.setContentType(contentType);
        }
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            try {
                long duration = DateUtils.getDuration((String)lastModified);
                Date currentDateLessDuration = this.getCurrentDateLessDuration(duration);
                DateRangeQuery.DateRange dateRange = new DateRangeQuery.DateRange(currentDateLessDuration, null, true, false);
                searchQueryParams.setLastModified(dateRange);
            }
            catch (InvalidDurationException e) {
                throw new IllegalArgumentException(i18NBean.getText("search.error.invalid-date-period", (Object[])new String[]{StringEscapeUtils.escapeHtml4((String)lastModified)}));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)contributor)) {
            searchQueryParams.setContributor(this.userAccessor.getUserByName(contributor));
        }
        searchQueryParams.setSearchQueryFilter((SearchQuery)new NonViewableCustomContentTypeQuery(this.pluginAccessor));
        ISearch search = this.buildSiteSearch(searchQueryParams, maxLimit);
        try {
            searchResults = this.searchManager.search(search);
        }
        catch (IllegalArgumentException e) {
            throw new MacroException(i18NBean.getText("search.error.invalid-query-params", (Object[])new String[]{StringEscapeUtils.escapeHtml4((String)searchQueryParams.toString())}), (Throwable)e);
        }
        catch (InvalidSearchException e) {
            throw new MacroException(i18NBean.getText("search.error.fail-for-term", (Object[])new String[]{StringEscapeUtils.escapeHtml4((String)searchQueryParams.getQuery())}), (Throwable)e);
        }
        List results = searchResults.getAll();
        Map<String, Object> contextMap = this.getDefaultVelocityContext();
        contextMap.put("searchResults", results);
        contextMap.put("totalSearchResults", results.size());
        contextMap.put("maxLimit", maxLimit);
        contextMap.put("query", userEnteredQuery);
        contextMap.put("generalUtil", GeneralUtil.INSTANCE);
        try {
            return this.getRenderedTemplate(contextMap);
        }
        catch (Exception e) {
            throw new MacroException("Error while trying to assemble the search result!", (Throwable)e);
        }
    }

    private static Integer convertToInteger(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        try {
            DecimalFormat parseFormat = new DecimalFormat("###############");
            return parseFormat.parse(obj.toString()).intValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    @VisibleForTesting
    protected ISearch buildSiteSearch(SearchQueryParameters searchQueryParameters, Integer maxLimit) {
        return this.predefinedSearchBuilder.buildSiteSearch(searchQueryParameters, 0, maxLimit.intValue());
    }

    protected Map<String, Object> getDefaultVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }

    protected String getRenderedTemplate(Map<String, Object> contextMap) {
        return this.velocityHelperService.getRenderedTemplate("com/atlassian/confluence/plugins/macros/advanced/search.vm", contextMap);
    }

    protected Date getCurrentDateLessDuration(long duration) {
        return new Date(System.currentTimeMillis() - duration * 1000L);
    }
}

