/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced.recentupdate.ajax;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.dmz.hibernate.AnyTypeDaoInternal;
import com.atlassian.confluence.plugins.macros.advanced.recentupdate.DefaultUpdateItemFactory;
import com.atlassian.confluence.plugins.macros.advanced.recentupdate.RecentChangesSearchBuilder;
import com.atlassian.confluence.plugins.macros.advanced.recentupdate.Theme;
import com.atlassian.confluence.plugins.macros.advanced.recentupdate.UpdateItem;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchTokenExpiredException;
import com.atlassian.confluence.search.v2.SearchWithToken;
import com.atlassian.confluence.search.v2.SiteSearchPermissionsQueryFactory;
import com.atlassian.confluence.util.actions.DisplayMapper;
import com.atlassian.plugin.PluginAccessor;
import java.util.LinkedList;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChangesAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(AbstractChangesAction.class);
    private SearchManager searchManager;
    private ContextPathHolder contextPathHolder;
    private DisplayMapper contentTypesDisplayMapper;
    private PluginAccessor pluginAccessor;
    private SiteSearchPermissionsQueryFactory siteSearchPermissionsQueryFactory;
    private AnyTypeDaoInternal anyTypeDao;
    private String authors;
    private String contentType;
    private String spaceKeys;
    private String labels;
    private int startIndex;
    private int pageSize;
    private long searchToken;
    private String nextPageUrl;
    List<UpdateItem> updateItems;

    public String execute() throws Exception {
        SearchResults searchResults;
        RecentChangesSearchBuilder searchBuilder = new RecentChangesSearchBuilder(this.pluginAccessor, this.userAccessor, this.siteSearchPermissionsQueryFactory).withLabels(this.labels).withAuthors(this.authors).withContentTypes(this.contentType).withSpaceKeys(this.spaceKeys);
        if (this.searchToken > 0L) {
            searchBuilder.withSearchToken(this.searchToken);
        }
        if (this.startIndex >= 0) {
            searchBuilder.withStartIndex(this.startIndex);
        }
        if (this.pageSize > 0) {
            searchBuilder.withPageSize(this.pageSize);
        }
        if (this.searchToken > 0L) {
            try {
                searchResults = this.searchManager.search(searchBuilder.buildSearchWithToken());
            }
            catch (SearchTokenExpiredException e) {
                this.addActionError(this.getText("recently.updated.search.token.expired"));
                return "input";
            }
            catch (InvalidSearchException e) {
                log.debug("Invalid search", (Throwable)e);
                this.addActionError(e.getMessage());
                return "input";
            }
        }
        try {
            searchResults = this.searchManager.search(searchBuilder.buildSearch());
        }
        catch (InvalidSearchException e) {
            log.debug("Invalid search", (Throwable)e);
            this.addActionError(e.getMessage());
            return "input";
        }
        if (!searchResults.isLastPage()) {
            SearchWithToken nextPageSearch = searchResults.getNextPageSearch();
            searchBuilder.withStartIndex(nextPageSearch.getStartOffset()).withPageSize(nextPageSearch.getLimit()).withSearchToken(nextPageSearch.getSearchToken());
            this.nextPageUrl = searchBuilder.buildSearchUrl(this.getTheme(), this.contextPathHolder.getContextPath());
        }
        DefaultUpdateItemFactory updateItemFactory = new DefaultUpdateItemFactory(this.getDateFormatter(), this.getI18n(), this.contentTypesDisplayMapper, this.pluginAccessor, this.anyTypeDao);
        this.updateItems = new LinkedList<UpdateItem>();
        for (SearchResult searchResult : searchResults) {
            UpdateItem updateItem = updateItemFactory.get(searchResult);
            if (updateItem == null) continue;
            this.updateItems.add(updateItem);
        }
        return super.execute();
    }

    protected abstract Theme getTheme();

    @StrutsParameter
    public void setAuthors(String authors) {
        this.authors = authors;
    }

    @StrutsParameter
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @StrutsParameter
    public void setSearchManager(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    @StrutsParameter
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @StrutsParameter
    public void setSpaceKeys(String spaceKeys) {
        this.spaceKeys = spaceKeys;
    }

    @StrutsParameter
    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getNextPageUrl() {
        return this.nextPageUrl;
    }

    @StrutsParameter
    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public List<UpdateItem> getUpdateItems() {
        return this.updateItems;
    }

    public void setContentTypesDisplayMapper(DisplayMapper contentTypesDisplayMapper) {
        this.contentTypesDisplayMapper = contentTypesDisplayMapper;
    }

    @StrutsParameter
    public void setSearchToken(long searchToken) {
        this.searchToken = searchToken;
    }

    public void setContextPathHolder(ContextPathHolder contextPathHolder) {
        this.contextPathHolder = contextPathHolder;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setSiteSearchPermissionsQueryFactory(SiteSearchPermissionsQueryFactory siteSearchPermissionsQueryFactory) {
        this.siteSearchPermissionsQueryFactory = siteSearchPermissionsQueryFactory;
    }

    public void setAnyTypeDao(AnyTypeDaoInternal anyTypeDao) {
        this.anyTypeDao = anyTypeDao;
    }
}

