/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced.xhtml;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.LinkRenderer;
import com.atlassian.confluence.content.render.xhtml.StaxUtils;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.XmlStreamWriterTemplate;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.macro.ContentFilteringMacro;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AddressablePage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.macros.advanced.BulkPermissionHelper;
import com.atlassian.confluence.plugins.macros.advanced.analytics.ChildrenMacroMetrics;
import com.atlassian.confluence.plugins.macros.advanced.xhtml.AdvancedMacrosExcerpter;
import com.atlassian.confluence.plugins.macros.advanced.xhtml.ChildrenMacroHelper;
import com.atlassian.confluence.plugins.macros.advanced.xhtml.ExcerptType;
import com.atlassian.confluence.renderer.ContentIncludeStack;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.ContentComparatorFactory;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.atlassian.webresource.api.WebResourceManager;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenMacro
extends ContentFilteringMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(ChildrenMacro.class);
    private static final String PAGE_LIMIT_PARAMETER_NAME = "confluence.child-macro.page-limit";
    private static final int PAGE_LIMIT = Integer.getInteger("confluence.child-macro.page-limit", Integer.MAX_VALUE);
    private static final String MAX_DEPTH_PARAMETER_NAME = "confluence.child-macro.max-depth";
    private static final int MAX_DEPTH = Integer.getInteger("confluence.child-macro.max-depth", Integer.MAX_VALUE);
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private final LinkRenderer viewLinkRenderer;
    private final PermissionManager permissionManager;
    private final ContentPermissionManager contentPermissionManager;
    private ConfluenceActionSupport confluenceActionSupport;
    private final WebResourceManager webResourceManager;
    private final EventPublisher eventPublisher;
    private final AdvancedMacrosExcerpter advancedMacrosExcerpter;
    private final XmlStreamWriterTemplate xmlStreamWriterTemplate;
    private final BulkPermissionHelper bulkPermissionHelper;
    private final GlobalSettingsManager settingsManager;
    private final ChildrenMacroHelper childrenMacroHelper;
    private final HttpContext httpContext;
    private Comparator<Page> sort;
    private final AtomicReference<String> baseUrl = new AtomicReference();

    public ChildrenMacro(PageManager pageManager, SpaceManager spaceManager, LinkRenderer viewLinkRenderer, PermissionManager permissionManager, ContentPermissionManager contentPermissionManager, WebResourceManager webResourceManager, EventPublisher eventPublisher, AdvancedMacrosExcerpter advancedMacrosExcerpter, XmlStreamWriterTemplate xmlStreamWriterTemplate, BulkPermissionHelper bulkPermissionHelper, GlobalSettingsManager settingsManager, ChildrenMacroHelper childrenMacroHelper, HttpContext httpContext) {
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.viewLinkRenderer = viewLinkRenderer;
        this.permissionManager = permissionManager;
        this.contentPermissionManager = contentPermissionManager;
        this.webResourceManager = webResourceManager;
        this.eventPublisher = eventPublisher;
        this.advancedMacrosExcerpter = advancedMacrosExcerpter;
        this.xmlStreamWriterTemplate = xmlStreamWriterTemplate;
        this.bulkPermissionHelper = bulkPermissionHelper;
        this.settingsManager = settingsManager;
        this.childrenMacroHelper = childrenMacroHelper;
        this.httpContext = httpContext;
    }

    public boolean isInline() {
        return this.getOutputType() == Macro.OutputType.INLINE;
    }

    public boolean hasBody() {
        return this.getBodyType() != Macro.BodyType.NONE;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        List<Page> children;
        int depth;
        StopWatch watch = StopWatch.createStarted();
        this.baseUrl.set(this.calculateBaseUrl());
        HashMap<Long, List<Page>> fullPageTree = new HashMap<Long, List<Page>>();
        AtomicInteger renderedPageCounter = new AtomicInteger();
        ChildrenMacroMetrics.Builder metrics = ChildrenMacroMetrics.builder();
        ExcerptType excerptType = this.disableExcerptIfRequired(ExcerptType.fromString(parameters.get("excerptType")));
        Helper helper = new Helper(metrics, context, excerptType);
        this.webResourceManager.requireResource("confluence.macros.advanced:children-resource");
        try {
            depth = this.calculateDepth(parameters);
        }
        catch (NumberFormatException e) {
            return RenderUtils.blockError((String)this.getConfluenceActionSupport().getText("children.error.unable-to-render"), (String)this.getConfluenceActionSupport().getText("children.error.invalid-depth", new String[]{StringEscapeUtils.escapeHtml4((String)parameters.get("depth"))}));
        }
        String pageTitle = parameters.get("page");
        try {
            children = pageTitle != null && (pageTitle.equals("/") || pageTitle.endsWith(":")) ? helper.getRootPagesForSpace(pageTitle, depth, fullPageTree) : helper.getChildrenFromPage(pageTitle, depth, fullPageTree);
        }
        catch (IllegalArgumentException e) {
            return RenderUtils.blockError((String)this.getConfluenceActionSupport().getText("children.error.unable-to-render"), (String)e.getMessage());
        }
        this.sort = this.configureComparator(parameters);
        if (this.sort != null) {
            children.sort(this.sort);
        }
        if (StringUtils.isNotEmpty((CharSequence)parameters.get("first"))) {
            try {
                int first = Integer.parseInt(parameters.get("first"));
                if (first > 0 && first < children.size()) {
                    children = children.subList(0, first);
                }
            }
            catch (NumberFormatException first) {
                // empty catch block
            }
        }
        log.debug("Child macro parameters: {}", parameters);
        String output = helper.render(parameters, children, this.limitDepthIfRequired(depth), renderedPageCounter, fullPageTree);
        watch.stop();
        boolean permissionsExempt = this.bulkPermissionHelper.isPermissionExempt((User)AuthenticatedUserThreadLocal.get());
        metrics.setPermissionsExempt(permissionsExempt);
        metrics.setOverallDuration(watch.getDuration().toMillis());
        metrics.setRenderedLinksTotal(renderedPageCounter.get());
        metrics.bulkPermissionsOptions(this.childrenMacroHelper.shouldCallBulkPermissionsAPI(excerptType), this.bulkPermissionHelper.isBulkPermissionsUpAndRunning());
        ChildrenMacroMetrics finalMetrics = metrics.build();
        this.eventPublisher.publish((Object)finalMetrics);
        log.debug("Child Macro Metrics: permissions for {} children were checked in {} ms ({} invocations), {} excerpts were rendered in {} ms. Macro rendering took {} ms. {} links were rendered. Bulk permissions service was used: {}, up and running: {}. Permissions exempt: {}", new Object[]{finalMetrics.getPermittedChildrenFetchItemTotal(), finalMetrics.getPermittedChildrenFetchMillis(), finalMetrics.getPermittedChildrenFetchInvocationCount(), finalMetrics.getExcerptSummariseInvocationCount(), finalMetrics.getExcerptSumariseMillis(), watch.getDuration().toMillis(), renderedPageCounter.get(), this.childrenMacroHelper.shouldCallBulkPermissionsAPI(excerptType), this.bulkPermissionHelper.isBulkPermissionsUpAndRunning(), permissionsExempt});
        if (this.bulkPermissionHelper.shouldPrintDebugInformation()) {
            return "<div class=\"debug-information-block\"><header><h1>Debug information</h1><small>This block is displayed because 'force-use-bulk-permissions' GET parameter was provided</small></header><p>Fast permissions up and running:" + this.bulkPermissionHelper.isBulkPermissionsUpAndRunning() + "</p><p><b>Fast permissions API called:" + this.childrenMacroHelper.shouldCallBulkPermissionsAPI(excerptType) + "</b></p><p>Pages processed:" + renderedPageCounter.get() + "</p><p>Macro rendering time:" + String.valueOf(watch) + "</p></div>" + output;
        }
        return output;
    }

    private int calculateDepth(Map<String, String> parameters) {
        if ("true".equalsIgnoreCase(parameters.get("all")) || "all".equalsIgnoreCase(parameters.get("depth"))) {
            return 0;
        }
        if (StringUtils.isNotEmpty((CharSequence)parameters.get("depth"))) {
            return Integer.parseInt(parameters.get("depth"));
        }
        return 1;
    }

    private ExcerptType disableExcerptIfRequired(ExcerptType excerptType) {
        if (!ExcerptType.NONE.equals((Object)excerptType) && this.childrenMacroHelper.getChildrenMacroBrowserSettings().isExcerptGenerationDisabled()) {
            log.debug("Excerpt generation is disabled in Child Macro, parameter 'Display Excerpt' was set to 'NONE'");
            return ExcerptType.NONE;
        }
        return excerptType;
    }

    private int limitDepthIfRequired(int depth) {
        int newDepth;
        int n = newDepth = depth == 0 && MAX_DEPTH != Integer.MAX_VALUE ? MAX_DEPTH : Math.min(depth, MAX_DEPTH);
        if (newDepth != depth) {
            log.debug("Child Macro depth parameter was decreased from {} to {} by the system variable ({})", new Object[]{depth != 0 ? Integer.valueOf(depth) : "unlimited", newDepth, MAX_DEPTH_PARAMETER_NAME});
        }
        return newDepth;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(MacroExecutionContext ctx) throws MacroException {
        try {
            return this.execute(ctx.getParams(), ctx.getBody(), (ConversionContext)new DefaultConversionContext((RenderContext)ctx.getPageContext()));
        }
        catch (MacroExecutionException ex) {
            throw new MacroException(ex.getCause() != null ? ex.getCause() : ex);
        }
    }

    private Comparator<Page> configureComparator(Map<String, String> parameters) {
        String sortType = parameters.get("sort");
        boolean reverse = Boolean.parseBoolean(parameters.get("reverse"));
        return ContentComparatorFactory.getComparator((String)sortType, (boolean)reverse);
    }

    protected ConfluenceActionSupport getConfluenceActionSupport() {
        if (null == this.confluenceActionSupport) {
            this.confluenceActionSupport = new ConfluenceActionSupport();
            ContainerManager.autowireComponent((Object)this.confluenceActionSupport);
        }
        return this.confluenceActionSupport;
    }

    private String calculateBaseUrl() {
        HttpServletRequest request = this.httpContext.getActiveRequest();
        return request != null ? request.getContextPath() : this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    private class Helper {
        private final ChildrenMacroMetrics.Builder metrics;
        private final ConversionContext conversionContext;
        private final PageContext pageContext;
        private final ExcerptType excerptType;

        Helper(ChildrenMacroMetrics.Builder metrics, ConversionContext conversionContext, ExcerptType excerptType) {
            this.metrics = metrics;
            this.conversionContext = conversionContext;
            this.pageContext = conversionContext != null && conversionContext.getPageContext() != null ? conversionContext.getPageContext() : new PageContext();
            this.excerptType = excerptType;
        }

        private String render(Map<String, String> parameters, List<Page> children, int depth, AtomicInteger renderedPageCounter, Map<Long, List<Page>> fullPageTree) throws MacroExecutionException {
            this.metrics.renderOptions(this.excerptType, depth);
            if (StringUtils.isNotEmpty((CharSequence)parameters.get("style"))) {
                String style = parameters.get("style");
                if (style.matches("h[1-6]")) {
                    return this.printChildrenUnderHeadings(children, depth, style.charAt(1), renderedPageCounter, fullPageTree);
                }
                return RenderUtils.blockError((String)ChildrenMacro.this.getConfluenceActionSupport().getText("children.error.unable-to-render"), (String)ChildrenMacro.this.getConfluenceActionSupport().getText("children.error.unknown-style", new String[]{StringEscapeUtils.escapeHtml4((String)style)}));
            }
            return this.printChildren(children, depth, renderedPageCounter, fullPageTree);
        }

        private List<Page> getRootPagesForSpace(String pageTitle, int depth, Map<Long, List<Page>> fullPageTree) {
            Space space = this.getSpace(pageTitle);
            if (ChildrenMacro.this.childrenMacroHelper.shouldCallBulkPermissionsAPI(this.excerptType)) {
                fullPageTree.putAll(ChildrenMacro.this.bulkPermissionHelper.getAllDescendants(space, null, depth));
                List<Page> topLevelPages = fullPageTree.getOrDefault(null, Collections.emptyList());
                if (this.pageContext.getEntity() != null) {
                    return topLevelPages.stream().filter(this.excludeCurrentPagePredicate(this.pageContext.getEntity().getId())).collect(Collectors.toList());
                }
                return topLevelPages;
            }
            List topLevelPages = ChildrenMacro.this.pageManager.getTopLevelPages(space);
            List pages = this.filterPermittedEntities(topLevelPages);
            if (this.pageContext.getEntity() != null) {
                this.removeThisPageFromList(pages, this.pageContext.getEntity());
            }
            return pages;
        }

        private Predicate<Page> excludeCurrentPagePredicate(long currentPageId) {
            return page -> page.getId() != currentPageId;
        }

        private Space getSpace(String pageTitle) {
            Space space = null;
            if ("/".equals(pageTitle)) {
                space = this.getCurrentSpace();
            } else if (pageTitle.length() > 1 && pageTitle.endsWith(":")) {
                space = ChildrenMacro.this.spaceManager.getSpace(pageTitle.substring(0, pageTitle.length() - 1));
            }
            if (!ChildrenMacro.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)space)) {
                throw new IllegalArgumentException(ChildrenMacro.this.getConfluenceActionSupport().getText("children.error.space-does-not-exists", new String[]{StringEscapeUtils.escapeHtml4((String)pageTitle)}));
            }
            return space;
        }

        private List filterPermittedEntities(List topLevelPages) {
            this.metrics.filterPermittedEntitiesStart(topLevelPages.size());
            List permittedEntities = ChildrenMacro.this.permissionManager.getPermittedEntities(AuthenticatedUserThreadLocal.get(), Permission.VIEW, topLevelPages);
            this.metrics.filterPermittedEntitiesFinish();
            return permittedEntities;
        }

        private Space getCurrentSpace() {
            ContentEntityObject obj = this.pageContext.getEntity();
            if (!(obj instanceof SpaceContentEntityObject)) {
                throw new IllegalArgumentException(ChildrenMacro.this.getConfluenceActionSupport().getText("children.error.content-not-belong-to-space"));
            }
            Space space = ((SpaceContentEntityObject)obj).getSpace();
            return space;
        }

        private void removeThisPageFromList(List<Page> pages, ContentEntityObject thisPage) {
            pages.removeIf(page -> page.getId() == thisPage.getId());
        }

        private List<Page> getChildrenFromPage(String pageTitle, int depth, Map<Long, List<Page>> fullPageTree) {
            ContentEntityObject target = this.getPage(this.pageContext, pageTitle);
            if (target == null) {
                if (StringUtils.isNotEmpty((CharSequence)pageTitle)) {
                    throw new IllegalArgumentException(ChildrenMacro.this.getConfluenceActionSupport().getText("children.error.page-not-found", new String[]{StringEscapeUtils.escapeHtml4((String)pageTitle)}));
                }
                throw new IllegalArgumentException(ChildrenMacro.this.getConfluenceActionSupport().getText("children.error.macro-works-on-only-pages"));
            }
            if (!ChildrenMacro.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)target)) {
                throw new IllegalArgumentException(ChildrenMacro.this.getConfluenceActionSupport().getText("children.error.page-not-found", new String[]{StringEscapeUtils.escapeHtml4((String)pageTitle)}));
            }
            if (!(target instanceof Page)) {
                throw new IllegalArgumentException(ChildrenMacro.this.getConfluenceActionSupport().getText("children.error.can-only-find-children-of-a-page", new String[]{target.getType()}));
            }
            Page page = (Page)target;
            if (ChildrenMacro.this.childrenMacroHelper.shouldCallBulkPermissionsAPI(this.excerptType)) {
                fullPageTree.putAll(ChildrenMacro.this.bulkPermissionHelper.getAllDescendants(page.getSpace(), page.getId(), depth));
                return fullPageTree.getOrDefault(page.getId(), Collections.emptyList());
            }
            return this.getPermittedChildren(page, fullPageTree);
        }

        private ContentEntityObject getPage(PageContext context, String pageTitleToRetrieve) {
            if (StringUtils.isEmpty((CharSequence)pageTitleToRetrieve)) {
                return this.getCurrentPage(context);
            }
            String spaceKey = context.getSpaceKey();
            String pageTitle = pageTitleToRetrieve;
            int colonIndex = pageTitleToRetrieve.indexOf(":");
            if (colonIndex != -1 && colonIndex != pageTitleToRetrieve.length() - 1) {
                spaceKey = pageTitleToRetrieve.substring(0, colonIndex);
                pageTitle = pageTitleToRetrieve.substring(colonIndex + 1);
            }
            return ChildrenMacro.this.pageManager.getPage(spaceKey, pageTitle);
        }

        private ContentEntityObject getCurrentPage(PageContext context) {
            ContentEntityObject entity = ContentIncludeStack.peek();
            if (entity instanceof Page) {
                return entity;
            }
            return context.getEntity();
        }

        private String printChildren(List<Page> pages, int depth, AtomicInteger renderedPageCounter, Map<Long, List<Page>> fullPageTree) throws MacroExecutionException {
            StringBuilder buf = new StringBuilder();
            this.printChildren(pages, buf, depth, 0, renderedPageCounter, fullPageTree);
            return buf.toString();
        }

        private String printChildrenUnderHeadings(List<Page> children, int depth, char headerType, AtomicInteger renderedPageCounter, Map<Long, List<Page>> fullPageTree) throws MacroExecutionException {
            StringBuilder buffer = new StringBuilder();
            int pageCounter = 0;
            for (Page child : children) {
                renderedPageCounter.incrementAndGet();
                if (++pageCounter > PAGE_LIMIT) {
                    log.debug("Child Macro: page limit ({}) was reached. Current depth level is {}. Processing stopped. Limit was set by the system variable ({}).", new Object[]{PAGE_LIMIT, depth, ChildrenMacro.PAGE_LIMIT_PARAMETER_NAME});
                    return buffer.toString();
                }
                buffer.append("<h").append(headerType).append(">");
                buffer.append(this.makePageLink(child));
                buffer.append("</h").append(headerType).append(">\n");
                buffer.append(this.renderExcerpt(child, "<p>", "</p>\n"));
                if (depth == 1) continue;
                this.printChildren(this.getPermittedChildren(child, fullPageTree), buffer, depth - 1, pageCounter, renderedPageCounter, fullPageTree);
            }
            return buffer.toString();
        }

        private void printChildren(List<Page> children, StringBuilder buffer, int depth, int pageCounter, AtomicInteger renderedPageCounter, Map<Long, List<Page>> fullPageTree) throws MacroExecutionException {
            if (!children.isEmpty()) {
                if (ChildrenMacro.this.sort != null) {
                    children.sort(ChildrenMacro.this.sort);
                }
                buffer.append("<ul class='childpages-macro'>");
                for (Page child : children) {
                    renderedPageCounter.incrementAndGet();
                    if (++pageCounter > PAGE_LIMIT) {
                        log.debug("Child Macro: page limit ({}) was reached. Current depth level is {}. Processing stopped. Limit was set by the system variable ({}).", new Object[]{PAGE_LIMIT, depth, ChildrenMacro.PAGE_LIMIT_PARAMETER_NAME});
                        return;
                    }
                    buffer.append("<li>").append(this.makePageLink(child));
                    buffer.append(this.renderExcerpt(child, " &mdash; <span class=\"smalltext\">", "</span>"));
                    if (depth != 1) {
                        this.printChildren(this.getPermittedChildren(child, fullPageTree), buffer, depth - 1, pageCounter, renderedPageCounter, fullPageTree);
                    }
                    buffer.append("</li>");
                }
                buffer.append("</ul>");
            }
        }

        private String renderExcerpt(Page child, String legacyWrapperStart, String legacyWrapperEnd) {
            this.metrics.excerptSummariseStart();
            String summary = ChildrenMacro.this.advancedMacrosExcerpter.createExcerpt((ContentEntityObject)child, this.excerptType, this.conversionContext, legacyWrapperStart, legacyWrapperEnd);
            this.metrics.excerptSummariseFinish();
            return summary;
        }

        private List<Page> getPermittedChildren(Page child, Map<Long, List<Page>> fullPageTree) {
            if (ChildrenMacro.this.childrenMacroHelper.shouldCallBulkPermissionsAPI(this.excerptType)) {
                return fullPageTree.getOrDefault(child.getId(), Collections.emptyList());
            }
            this.metrics.permittedChildrenFetchStart();
            List children = ChildrenMacro.this.contentPermissionManager.getPermittedChildren(child, AuthenticatedUserThreadLocal.get());
            this.metrics.permittedChildrenFetchFinish(children.size());
            return children;
        }

        private String makePageLink(Page child) throws MacroExecutionException {
            try {
                this.metrics.renderPageLinkStart();
                String string = ChildrenMacro.this.childrenMacroHelper.shouldCallBulkPermissionsAPI(this.excerptType) ? this.renderLinkQuickly(child) : ChildrenMacro.this.viewLinkRenderer.render((ContentEntityObject)child, this.conversionContext);
                return string;
            }
            catch (XhtmlException e) {
                throw new MacroExecutionException((Throwable)e);
            }
            finally {
                this.metrics.renderPageLinkFinish();
            }
        }

        private String renderLinkQuickly(Page page) {
            Streamable streamable = Streamables.from((XmlStreamWriterTemplate)ChildrenMacro.this.xmlStreamWriterTemplate, (xmlStreamWriter, underlyingWriter) -> {
                xmlStreamWriter.writeStartElement("a");
                xmlStreamWriter.writeAttribute("href", ChildrenMacro.this.baseUrl.get() + AddressablePage.of((AbstractPage)page).getUrlPath());
                StaxUtils.writeRawXML((XMLStreamWriter)xmlStreamWriter, (Writer)underlyingWriter, (Streamable)Streamables.from((String)StringEscapeUtils.escapeHtml4((String)page.getTitle())));
                xmlStreamWriter.writeEndElement();
            });
            return Streamables.writeToString((Streamable)streamable);
        }
    }
}

