/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.advanced.xhtml;

import com.atlassian.confluence.plugins.macros.advanced.BulkPermissionHelper;
import com.atlassian.confluence.plugins.macros.advanced.model.ChildrenMacroBrowserSettings;
import com.atlassian.confluence.plugins.macros.advanced.xhtml.ExcerptType;
import com.atlassian.sal.api.features.DarkFeatureManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenMacroHelper {
    private static final Logger log = LoggerFactory.getLogger(ChildrenMacroHelper.class);
    public static final String DISABLE_EXCERPT_PARAMETER_NAME = "confluence.child-macro.disable-excerpt";
    private final BulkPermissionHelper bulkPermissionHelper;
    private final DarkFeatureManager darkFeatureManager;

    public ChildrenMacroHelper(BulkPermissionHelper bulkPermissionHelper, DarkFeatureManager darkFeatureManager) {
        this.bulkPermissionHelper = bulkPermissionHelper;
        this.darkFeatureManager = darkFeatureManager;
    }

    public boolean shouldCallBulkPermissionsAPI(ExcerptType excerptType) {
        if (excerptType == ExcerptType.NONE || this.excerptGenerationDisabled()) {
            return this.bulkPermissionHelper.shouldCallBulkPermissionsAPI();
        }
        return false;
    }

    private boolean excerptGenerationDisabled() {
        boolean excerptGenerationDisabled = Boolean.getBoolean(DISABLE_EXCERPT_PARAMETER_NAME) || this.darkFeatureManager.isEnabledForAllUsers(DISABLE_EXCERPT_PARAMETER_NAME).orElse(false) != false;
        log.debug("Excerpt generation disabled in Children Macro: {}", (Object)excerptGenerationDisabled);
        return excerptGenerationDisabled;
    }

    public ChildrenMacroBrowserSettings getChildrenMacroBrowserSettings() {
        ChildrenMacroBrowserSettings settings = new ChildrenMacroBrowserSettings();
        settings.setExcerptGenerationDisabled(this.excerptGenerationDisabled());
        return settings;
    }
}

