/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.serialblocklist.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import java.util.function.Predicate;

public class BlocklistConverter
implements Converter {
    private final Predicate<Class<?>> blocklist;

    public BlocklistConverter(Predicate<Class<?>> blocklist) {
        this.blocklist = blocklist;
    }

    public void marshal(Object o, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        throw new ForbiddenClassException(o.getClass());
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        throw new ForbiddenClassException(unmarshallingContext.getRequiredType());
    }

    public boolean canConvert(Class aClass) {
        return this.isBlocked(aClass);
    }

    protected boolean isBlocked(Class<?> clazz) {
        return !this.blocklist.test(clazz);
    }

    protected Class<?> checkClass(Class<?> clazz) {
        if (this.isBlocked(clazz)) {
            throw new ForbiddenClassException(clazz);
        }
        return clazz;
    }
}

