/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.serialblocklist.xstream;

import com.atlassian.security.serialblocklist.BlocklistConfigurator;
import com.atlassian.security.serialblocklist.xstream.BlocklistConverter;
import com.atlassian.security.serialblocklist.xstream.BlocklistConverterWrapper;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class BlocklistRestrictedXStream
extends XStream {
    private static final String BLOCKLIST_MESSAGE_TEMPLATE = "Class %s is blocklisted and cannot be allowed.";
    private static final int MAX_PRIORITY = 100000;
    private BlocklistConverter blocklistConverter;

    public BlocklistRestrictedXStream() {
    }

    public BlocklistRestrictedXStream(ReflectionProvider reflectionProvider) {
        super(reflectionProvider);
    }

    public BlocklistRestrictedXStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(hierarchicalStreamDriver);
    }

    public BlocklistRestrictedXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        super(reflectionProvider, hierarchicalStreamDriver);
    }

    public BlocklistRestrictedXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference) {
        super(reflectionProvider, driver, classLoaderReference);
    }

    public BlocklistRestrictedXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper) {
        super(reflectionProvider, driver, classLoaderReference, mapper);
    }

    public BlocklistRestrictedXStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry) {
        super(reflectionProvider, driver, classLoaderReference, mapper, converterLookup, converterRegistry);
    }

    protected final void setupConverters() {
        this.setupDefaultXStreamConverters();
        this.setupBlocklistConverter();
    }

    private void setupBlocklistConverter() {
        this.blocklistConverter = new BlocklistConverter(BlocklistPredicateHolder.INSTANCE);
        super.registerConverter((Converter)this.blocklistConverter, 100000);
    }

    protected void setupDefaultXStreamConverters() {
        super.setupConverters();
    }

    protected void setupImmutableTypes() {
        super.setupImmutableTypes();
    }

    public void registerConverter(Converter converter, int priority) {
        if (priority >= 100000) {
            throw new IllegalArgumentException("Priority must be less than 100000");
        }
        super.registerConverter(converter, priority);
    }

    public void registerConverter(SingleValueConverter converter, int priority) {
        if (priority >= 100000) {
            throw new IllegalArgumentException("Priority must be less than 100000");
        }
        super.registerConverter(converter, priority);
    }

    public void allowTypes(String[] names) {
        for (String typeName : names) {
            try {
                if (!this.isBlocklisted(Class.forName(typeName, false, this.getClassLoader()))) continue;
                throw new IllegalArgumentException(String.format(BLOCKLIST_MESSAGE_TEMPLATE, typeName));
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        super.allowTypes(names);
    }

    public void allowTypes(Class[] types) {
        for (Class type : types) {
            if (!this.isBlocklisted(type)) continue;
            throw new IllegalArgumentException(String.format(BLOCKLIST_MESSAGE_TEMPLATE, type.getName()));
        }
        super.allowTypes(types);
    }

    public void allowTypesByWildcard(String[] wildcards) {
        throw new UnsupportedOperationException("The method allowTypesByWildcard is blocked in BlocklistRestrictedXStream.");
    }

    public void allowTypesByRegExp(String[] regex) {
        throw new UnsupportedOperationException("The method allowTypesByRegExp is blocked in BlocklistRestrictedXStream.");
    }

    public void allowTypesByRegExp(Pattern[] patterns) {
        throw new UnsupportedOperationException("The method allowTypesByRegExp is blocked in BlocklistRestrictedXStream.");
    }

    public void allowTypeHierarchy(Class type) {
        if (this.isBlocklisted(type)) {
            throw new IllegalArgumentException(String.format(BLOCKLIST_MESSAGE_TEMPLATE, type.getName()));
        }
        super.allowTypeHierarchy(type);
    }

    public void registerLocalConverter(Class definedIn, String fieldName, Converter converter) {
        super.registerLocalConverter(definedIn, fieldName, (Converter)new BlocklistConverterWrapper(BlocklistPredicateHolder.INSTANCE, converter));
    }

    public void registerLocalConverter(Class definedIn, String fieldName, SingleValueConverter converter) {
        this.registerLocalConverter(definedIn, fieldName, (Converter)new SingleValueConverterWrapper(converter));
    }

    private boolean isBlocklisted(Class<?> clazz) {
        return this.blocklistConverter != null && this.blocklistConverter.isBlocked(clazz);
    }

    private static class BlocklistPredicateHolder {
        static final Predicate<Class<?>> INSTANCE = new BlocklistConfigurator().configure();

        private BlocklistPredicateHolder() {
        }
    }
}

