/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.hook.dmz.packages;

import com.atlassian.plugin.osgi.hook.dmz.PluginTypeDetector;
import com.atlassian.plugin.osgi.hook.dmz.packages.AlwaysFalseInternalPackageDetector;
import com.atlassian.plugin.osgi.hook.dmz.packages.DefaultInternalPackageDetector;
import com.atlassian.plugin.osgi.hook.dmz.packages.DmzPackagePatterns;
import com.atlassian.plugin.osgi.hook.dmz.packages.InternalPackageDetector;
import com.atlassian.plugin.osgi.hook.dmz.packages.PluginInternalPackageDetector;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;

public class ExportTypeBasedInternalPackageDetector
implements InternalPackageDetector {
    private final InternalPackageDetector forSystemBundle;
    private final InternalPackageDetector forInternalPlugins;
    private final InternalPackageDetector forExternalPlugins;
    private final PluginTypeDetector pluginTypeDetector;

    public ExportTypeBasedInternalPackageDetector(DmzPackagePatterns dmzPackagePatterns, PluginTypeDetector pluginTypeDetector) {
        this.forSystemBundle = new DefaultInternalPackageDetector(dmzPackagePatterns);
        this.forInternalPlugins = new PluginInternalPackageDetector(this.forSystemBundle);
        this.forExternalPlugins = new AlwaysFalseInternalPackageDetector();
        this.pluginTypeDetector = pluginTypeDetector;
    }

    @Override
    public boolean isInternalPackage(BundleCapability capability) {
        InternalPackageDetector internalPackageDetector = this.getDetectorBasedOnExportType(capability);
        return internalPackageDetector.isInternalPackage(capability);
    }

    @Override
    public boolean isDeprecatedPackage(BundleCapability capability) {
        InternalPackageDetector internalPackageDetector = this.getDetectorBasedOnExportType(capability);
        return internalPackageDetector.isDeprecatedPackage(capability);
    }

    private InternalPackageDetector getDetectorBasedOnExportType(BundleCapability bundleCapability) {
        Bundle bundle = bundleCapability.getRevision().getBundle();
        if (this.pluginTypeDetector.isSystemBundle(bundle)) {
            return this.forSystemBundle;
        }
        if (this.pluginTypeDetector.isInternalPlugin(bundle)) {
            return this.forInternalPlugins;
        }
        return this.forExternalPlugins;
    }
}

