/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.thirdparty;

import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.StreamsException;
import com.atlassian.streams.api.StreamsFeed;
import com.atlassian.streams.api.common.Iterables;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.spi.CancellableTask;
import com.atlassian.streams.spi.Filters;
import com.atlassian.streams.spi.StandardStreamsFilterOption;
import com.atlassian.streams.spi.StreamsActivityProvider;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.atlassian.streams.thirdparty.ThirdPartyStreamsEntryBuilder;
import com.atlassian.streams.thirdparty.api.Activity;
import com.atlassian.streams.thirdparty.api.ActivityQuery;
import com.atlassian.streams.thirdparty.api.ActivityService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Date;

public class ThirdPartyStreamsActivityProvider
implements StreamsActivityProvider {
    private final StreamsI18nResolver i18nResolver;
    private final ActivityService activityService;
    private final ThirdPartyStreamsEntryBuilder entryBuilder;
    private static final Ordering<Activity> byPostedDateDescending = new Ordering<Activity>(){

        public int compare(Activity a, Activity b) {
            return b.getZonedPostedDate().compareTo(a.getZonedPostedDate());
        }
    };

    public ThirdPartyStreamsActivityProvider(ActivityService activityService, StreamsI18nResolver i18nResolver, ThirdPartyStreamsEntryBuilder entryBuilder) {
        this.activityService = (ActivityService)Preconditions.checkNotNull((Object)activityService, (Object)"activityService");
        this.i18nResolver = (StreamsI18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.entryBuilder = (ThirdPartyStreamsEntryBuilder)Preconditions.checkNotNull((Object)entryBuilder, (Object)"entryBuilder");
    }

    public CancellableTask<StreamsFeed> getActivityFeed(final ActivityRequest activityRequest) throws StreamsException {
        return new CancellableTask<StreamsFeed>(){

            public StreamsFeed call() throws Exception {
                return new StreamsFeed(ThirdPartyStreamsActivityProvider.this.i18nResolver.getText("streams.thirdparty.title"), ThirdPartyStreamsActivityProvider.this.getEntries(activityRequest), Option.none(String.class));
            }

            public CancellableTask.Result cancel() {
                return CancellableTask.Result.INTERRUPT;
            }
        };
    }

    @VisibleForTesting
    protected Iterable<StreamsEntry> getEntries(ActivityRequest request) {
        Iterable<StreamsEntry> nextEntries = this.buildEntries(request, this.getActivities(request, 0));
        Object allEntries = ImmutableList.copyOf(nextEntries);
        for (int size = com.google.common.collect.Iterables.size(nextEntries); !com.google.common.collect.Iterables.isEmpty(nextEntries) && size < request.getMaxResults(); size += com.google.common.collect.Iterables.size(nextEntries)) {
            nextEntries = this.buildEntries(request, this.getActivities(request, size));
            if (com.google.common.collect.Iterables.isEmpty(nextEntries)) continue;
            allEntries = com.google.common.collect.Iterables.concat((Iterable)allEntries, nextEntries);
        }
        return Iterables.take((int)request.getMaxResults(), (Iterable)allEntries);
    }

    private Iterable<StreamsEntry> buildEntries(ActivityRequest request, Iterable<Activity> activities) {
        return com.google.common.collect.Iterables.transform((Iterable)Iterables.take((int)request.getMaxResults(), (Iterable)ThirdPartyStreamsActivityProvider.byPostedDateDescending().sortedCopy(activities)), this.toStreamsEntry());
    }

    @VisibleForTesting
    protected Iterable<Activity> getActivities(ActivityRequest request, int startIndex) {
        ActivityQuery.Builder query = ActivityQuery.builder().startDate((Option<Date>)Filters.getMinDate((ActivityRequest)request)).endDate((Option<Date>)Filters.getMaxDate((ActivityRequest)request)).userNames(Filters.getIsValues((Iterable)request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.USER.getKey(), Collections.emptyList()))).excludeUserNames(Filters.getNotValues((Iterable)request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.USER.getKey(), Collections.emptyList()))).providerKeys(Filters.getIsValues((Iterable)request.getProviderFiltersMap().getOrDefault("provider_name", Collections.emptyList()))).excludeProviderKeys(Filters.getNotValues((Iterable)request.getProviderFiltersMap().getOrDefault("provider_name", Collections.emptyList()))).maxResults(request.getMaxResults()).startIndex(startIndex);
        for (String projectKey : Filters.getProjectKeys((ActivityRequest)request)) {
            query.addEntityFilter("key", projectKey);
        }
        for (String projectKey : Filters.getNotProjectKeys((ActivityRequest)request)) {
            query.addExcludeEntityFilter("key", projectKey);
        }
        for (String issueKey : Filters.getIssueKeys((ActivityRequest)request)) {
            query.addEntityFilter(StandardStreamsFilterOption.ISSUE_KEY.getKey(), issueKey);
        }
        for (String issueKey : Filters.getNotIssueKeys((ActivityRequest)request)) {
            query.addExcludeEntityFilter(StandardStreamsFilterOption.ISSUE_KEY.getKey(), issueKey);
        }
        return this.activityService.activities(query.build());
    }

    private Function<Activity, StreamsEntry> toStreamsEntry() {
        return new Function<Activity, StreamsEntry>(){

            public StreamsEntry apply(Activity activity) {
                return ThirdPartyStreamsActivityProvider.this.entryBuilder.buildStreamsEntry(activity);
            }
        };
    }

    private static final Ordering<Activity> byPostedDateDescending() {
        return byPostedDateDescending;
    }
}

