/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.thirdparty.rest;

import com.atlassian.plugins.rest.api.util.RestUrlBuilder;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.streams.thirdparty.rest.resources.ThirdPartyStreamsCollectionResource;
import com.atlassian.streams.thirdparty.rest.resources.ThirdPartyStreamsResource;
import com.google.common.base.Preconditions;
import java.net.URI;

public final class ThirdPartyStreamsUriBuilder {
    private final ApplicationProperties applicationProperties;
    private final RestUrlBuilder restUrlBuilder;
    private final String ACTIVITIES_BASE = "/rest/activities/1.0";

    public ThirdPartyStreamsUriBuilder(ApplicationProperties applicationProperties, RestUrlBuilder restUrlBuilder) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.restUrlBuilder = (RestUrlBuilder)Preconditions.checkNotNull((Object)restUrlBuilder, (Object)"restUrlBuilder");
    }

    public URI buildActivityUri(Long activityId) {
        return this.buildActivityUriWithBaseUri(this.getBaseUri(), activityId);
    }

    public URI buildAbsoluteActivityUri(Long activityId) {
        return this.buildActivityUriWithBaseUri(this.getAbsoluteBaseUri(), activityId);
    }

    private URI buildActivityUriWithBaseUri(URI baseUri, Long activityId) {
        return this.restUrlBuilder.getUrlFor(baseUri, ThirdPartyStreamsResource.class, r -> r.get(activityId));
    }

    public URI buildActivityCollectionUri() {
        return this.buildActivityCollectionUri(10, 0);
    }

    public URI buildActivityCollectionUri(int maxResults, int startIndex) {
        return this.restUrlBuilder.getUrlFor(this.getBaseUri(), ThirdPartyStreamsCollectionResource.class, r -> r.fetchActivities(maxResults, startIndex));
    }

    private URI getBaseUri() {
        return URI.create(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE).concat("/rest/activities/1.0"));
    }

    private URI getAbsoluteBaseUri() {
        return URI.create(this.applicationProperties.getBaseUrl(UrlMode.CANONICAL).concat("/rest/activities/1.0"));
    }
}

