/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.thirdparty.spring;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.TransactionalAnnotationProcessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.rest.api.util.RestUrlBuilder;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.streams.api.FeedContentSanitizer;
import com.atlassian.streams.spi.SessionManager;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.atlassian.streams.spi.UserProfileAccessor;
import com.atlassian.streams.thirdparty.ActivityServiceActiveObjects;
import com.atlassian.streams.thirdparty.ActivityServiceActiveObjectsImpl;
import com.atlassian.streams.thirdparty.ActivityServiceDelegator;
import com.atlassian.streams.thirdparty.EntityAssociationProviders;
import com.atlassian.streams.thirdparty.ThirdPartyStreamsEntryBuilder;
import com.atlassian.streams.thirdparty.api.ActivityService;
import com.atlassian.streams.thirdparty.rest.LinkBuilder;
import com.atlassian.streams.thirdparty.rest.ThirdPartyStreamsUriBuilder;
import com.atlassian.streams.thirdparty.rest.representations.RepresentationFactory;
import com.atlassian.streams.thirdparty.rest.representations.RepresentationFactoryImpl;
import com.atlassian.streams.thirdparty.spring.ImportBeans;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ImportBeans.class})
public class SpringBeans {
    @Bean
    TransactionalAnnotationProcessor transactionalAnnotationProcessor(ActiveObjects ao) {
        return new TransactionalAnnotationProcessor(ao);
    }

    @Bean
    ActivityServiceDelegator activityService(ActivityServiceActiveObjects activityServiceActiveObjects) {
        return new ActivityServiceDelegator(activityServiceActiveObjects);
    }

    @Bean
    FactoryBean<ServiceRegistration> exportActivityService(ActivityServiceDelegator activityService) {
        return OsgiServices.exportOsgiService(activityService, ExportOptions.as(ActivityService.class, new Class[0]));
    }

    @Bean
    ActivityServiceActiveObjects activityServiceActiveObjects(ActiveObjects activeObjects, EntityAssociationProviders entityAssociationProviders, FeedContentSanitizer feedSanitizer, UserManager userManager, UserProfileAccessor userProfileAccessor, ApplicationProperties applicationProperties) {
        return new ActivityServiceActiveObjectsImpl(activeObjects, entityAssociationProviders, feedSanitizer, userManager, userProfileAccessor, applicationProperties);
    }

    @Bean
    ThirdPartyStreamsUriBuilder uriBuilder(ApplicationProperties applicationProperties, RestUrlBuilder restUrlBuilder) {
        return new ThirdPartyStreamsUriBuilder(applicationProperties, restUrlBuilder);
    }

    @Bean
    LinkBuilder linkBuilder(ThirdPartyStreamsUriBuilder uriBuilder) {
        return new LinkBuilder(uriBuilder);
    }

    @Bean
    ThirdPartyStreamsEntryBuilder thirdPartyStreamsEntryBuilder(StreamsI18nResolver streamsI18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        return new ThirdPartyStreamsEntryBuilder(streamsI18nResolver, webResourceUrlProvider);
    }

    @Bean
    EntityAssociationProviders entityAssociationProviders(PluginAccessor pluginAccessor, @Qualifier(value="sessionManager") SessionManager sessionManager, TransactionTemplate transactionTemplate, UserManager userManager) {
        return new EntityAssociationProviders(pluginAccessor, sessionManager, transactionTemplate, userManager);
    }

    @Bean
    RepresentationFactory representationFactory(LinkBuilder linkBuilder) {
        return new RepresentationFactoryImpl(linkBuilder);
    }
}

