/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.graphql.resource;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.settings.SettingsService;
import com.atlassian.confluence.plugins.graphql.resource.ConfluenceGraphQLRestEndpoint;
import com.atlassian.graphql.utils.GraphQLUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.google.common.io.CharStreams;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.idl.SchemaPrinter;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Qualifier;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="")
public class GraphResource {
    private final ConfluenceGraphQLRestEndpoint endpoint;
    private final DarkFeatureManager darkFeatureManager;
    private final SettingsService settingsService;

    @Inject
    public GraphResource(ConfluenceGraphQLRestEndpoint endpoint, @ComponentImport @Qualifier(value="darkFeatureManager") DarkFeatureManager darkFeatureManager, @ComponentImport SettingsService settingsService) {
        this.endpoint = endpoint;
        this.darkFeatureManager = darkFeatureManager;
        this.settingsService = settingsService;
    }

    @POST
    @Path(value="")
    @ScopesAllowed(requiredScope={"READ"})
    public Response query(String requestString, @QueryParam(value="query") String query, @Context UriInfo uriInfo, @Context HttpServletRequest request) throws Exception {
        if (!this.darkFeatureManager.isEnabledForCurrentUser("graphql").orElse(false).booleanValue()) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)this.endpoint.execute(requestString, query, uriInfo, request)).build();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getGraphiqlApp() throws Exception {
        if (!this.darkFeatureManager.isEnabledForCurrentUser("graphiql").orElse(false).booleanValue()) {
            return Response.status((int)404).build();
        }
        InputStream templateResource = GraphResource.class.getClassLoader().getResourceAsStream("graphiql.html");
        String template = CharStreams.toString((Readable)new InputStreamReader(templateResource, StandardCharsets.UTF_8));
        template = template.replace("{basePath}", this.settingsService.getGlobalSettings().getBaseUrl());
        return Response.ok((Object)template).build();
    }

    @GET
    @Path(value="_schema")
    public Response getSchema() {
        return this.getSchema(null, null);
    }

    @GET
    @Path(value="_schema/{field}")
    public Response getSchema(@PathParam(value="field") String field) {
        return this.getSchema(field, null);
    }

    @GET
    @Path(value="_schema/{field1}/{field2}")
    public Response getSchema(@PathParam(value="field1") String field1, @PathParam(value="field2") String field2) {
        GraphQLObjectType type = this.endpoint.getSchema().getQueryType();
        if (field1 != null && !field1.isEmpty()) {
            type = this.navigateToFieldType((GraphQLOutputType)type, field1);
        }
        if (field2 != null && !field2.isEmpty()) {
            type = this.navigateToFieldType((GraphQLOutputType)type, field2);
        }
        SchemaPrinter.Options options = SchemaPrinter.Options.defaultOptions().includeScalarTypes(true).includeDirectiveDefinitions(false).includeDirectives(true);
        SchemaPrinter printer = new SchemaPrinter(options);
        return Response.ok((Object)(type == null ? "" : printer.print(this.endpoint.getSchema()))).build();
    }

    private GraphQLOutputType navigateToFieldType(GraphQLOutputType type, String fieldName) {
        GraphQLFieldDefinition fieldDefinition;
        if (type == null) {
            return null;
        }
        if ((type = (GraphQLOutputType)GraphQLUtils.unwrap((GraphQLType)type, Collections.emptyMap())) instanceof GraphQLFieldsContainer && (fieldDefinition = ((GraphQLFieldsContainer)type).getFieldDefinition(fieldName)) != null) {
            return fieldDefinition.getType();
        }
        return null;
    }
}

