/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.retentionrules.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.retention.GlobalRetentionPolicy;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.retention.RetentionFeatureChecker;
import com.atlassian.confluence.retention.GlobalRetentionPolicyService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class GlobalRetentionPolicyResource {
    private final Logger logger = LoggerFactory.getLogger(GlobalRetentionPolicyResource.class);
    private final GlobalRetentionPolicyService retentionRulesSettingsService;
    private final RetentionFeatureChecker featureChecker;

    @Inject
    public GlobalRetentionPolicyResource(@ComponentImport GlobalRetentionPolicyService retentionRulesSettingsService, @ComponentImport RetentionFeatureChecker featureChecker) {
        this.retentionRulesSettingsService = Objects.requireNonNull(retentionRulesSettingsService);
        this.featureChecker = Objects.requireNonNull(featureChecker);
    }

    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getGlobalRetentionPolicy() {
        if (!this.featureChecker.isFeatureAvailable()) {
            return this.notFound();
        }
        try {
            return Response.ok((Object)this.retentionRulesSettingsService.getPolicy()).build();
        }
        catch (PermissionException ex) {
            this.logger.debug("Permission error", (Throwable)ex);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (NotFoundException nfe) {
            return this.notFound();
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve Global Retention rules.", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setGlobalRetentionPolicy(GlobalRetentionPolicy policy) {
        if (!this.featureChecker.isFeatureAvailable()) {
            return this.notFound();
        }
        try {
            List validations = policy.validate();
            if (!validations.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)validations).build();
            }
            this.retentionRulesSettingsService.savePolicy(policy);
            return Response.ok((Object)policy).build();
        }
        catch (PermissionException ex) {
            this.logger.debug("Permission error", (Throwable)ex);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (Exception e) {
            this.logger.error("Failed to save Global Retention rules.", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

