/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.retentionrules.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.retention.RetentionFeatureChecker;
import com.atlassian.confluence.retention.RetentionPolicyPermissionService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/space/{spaceKey}/edit-permission")
public class SpaceRetentionPolicyPermissionResource {
    private final RetentionFeatureChecker featureChecker;
    private final RetentionPolicyPermissionService retentionPolicyPermissionService;

    @Inject
    public SpaceRetentionPolicyPermissionResource(@ComponentImport RetentionFeatureChecker featureChecker, @ComponentImport RetentionPolicyPermissionService retentionPolicyPermissionService) {
        this.featureChecker = featureChecker;
        this.retentionPolicyPermissionService = retentionPolicyPermissionService;
    }

    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getUserPermissionForSpace(@PathParam(value="spaceKey") String spaceKey) {
        if (!this.featureChecker.isFeatureAvailable()) {
            return Response.status((int)404).build();
        }
        Boolean canEdit = this.retentionPolicyPermissionService.getUserRetentionPolicyPermissionForSpace(spaceKey);
        return Response.ok((Object)canEdit).build();
    }
}

