/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.retentionrules.rest;

import com.atlassian.confluence.api.service.retention.SoftCleanupStatusService;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/job")
@AdminOnly
public class VersionsRemovalJobResource {
    private final Logger logger = LoggerFactory.getLogger(VersionsRemovalJobResource.class);
    private final SoftCleanupStatusService softCleanupStatusService;

    @Inject
    public VersionsRemovalJobResource(@ComponentImport SoftCleanupStatusService softCleanupStatusService) {
        this.softCleanupStatusService = softCleanupStatusService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getJobStatus() {
        try {
            return Response.ok((Object)this.softCleanupStatusService.getCurrentStatus()).build();
        }
        catch (NotAuthorizedException ex) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve Versions removal job status.", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

