/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.whitelist;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.ReadThroughCache;
import com.atlassian.confluence.cache.ConfluenceCache;
import com.atlassian.confluence.impl.cache.whitelist.CacheOperationsWhitelist;
import com.atlassian.confluence.impl.cache.whitelist.CacheOperationsWhitelistService;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;

final class AopCacheOperationsWhitelistService
implements CacheOperationsWhitelistService {
    private final CacheOperationsWhitelist whitelist;
    private final Map<Method, CacheOperationsWhitelist.Operation> methodOperations;

    AopCacheOperationsWhitelistService(CacheOperationsWhitelist whitelist) throws NoSuchMethodException {
        this.whitelist = whitelist;
        this.methodOperations = Map.of(Cache.class.getMethod("put", Object.class, Object.class), CacheOperationsWhitelist.Operation.PUT, Cache.class.getMethod("putIfAbsent", Object.class, Object.class), CacheOperationsWhitelist.Operation.PUT, ConfluenceCache.class.getMethod("putIfAbsent", Object.class, Object.class), CacheOperationsWhitelist.Operation.PUT, Cache.class.getMethod("replace", Object.class, Object.class, Object.class), CacheOperationsWhitelist.Operation.REPLACE, ReadThroughCache.class.getMethod("remove", Object.class, Object.class), CacheOperationsWhitelist.Operation.REMOVE_CONDITIONAL, Cache.class.getMethod("addListener", CacheEntryListener.class, Boolean.TYPE), CacheOperationsWhitelist.Operation.LISTENER);
    }

    @Override
    public <K, V> ConfluenceCache<K, V> wrap(ConfluenceCache<K, V> cache) {
        return new WhitelistProxyFactory<K, V>().createProxy(cache);
    }

    class WhitelistProxyFactory<K, V> {
        WhitelistProxyFactory() {
        }

        public ConfluenceCache<K, V> createProxy(ConfluenceCache<K, V> target) {
            ProxyFactory proxyFactory = new ProxyFactory(target);
            proxyFactory.addAdvisor(this.advisor(target));
            Object proxy = proxyFactory.getProxy(this.getClass().getClassLoader());
            return (ConfluenceCache)proxy;
        }

        private Advisor advisor(ConfluenceCache<K, V> cache) {
            return new StaticMethodMatcherPointcutAdvisor((Advice)this.assertIsPermitted(cache)){

                public boolean matches(Method method, Class<?> targetClass) {
                    return WhitelistProxyFactory.this.isMethodOn(method, Set.of(Cache.class, ReadThroughCache.class, ConfluenceCache.class));
                }
            };
        }

        private boolean isMethodOn(Method method, Collection<Class<?>> types) {
            return types.contains(method.getDeclaringClass());
        }

        private MethodBeforeAdvice assertIsPermitted(ConfluenceCache<K, V> cache) {
            return (method, args, target) -> this.assertIsPermitted(cache, method);
        }

        private void assertIsPermitted(ConfluenceCache<K, V> cache, Method method) {
            CacheOperationsWhitelist.Operation operation = AopCacheOperationsWhitelistService.this.methodOperations.get(method);
            if (operation != null) {
                AopCacheOperationsWhitelistService.this.whitelist.assertPermitted(operation, cache);
            }
        }
    }
}

