/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.softwareproject;

import com.atlassian.confluence.plugins.createcontent.api.events.SpaceBlueprintHomePageCreateEvent;
import com.atlassian.confluence.plugins.softwareproject.components.AppLinkCreator;
import com.atlassian.confluence.plugins.softwareproject.components.LabelCreator;
import com.atlassian.confluence.plugins.softwareproject.components.SampleAttachmentCreator;
import com.atlassian.confluence.search.IndexManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceConstants;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateSpaceHomePageEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSpaceHomePageEventListener.class);
    private static final String SOFTWARE_PROJECT_SPACE_COMPLETE_KEY = "com.atlassian.confluence.plugins.confluence-software-project:sp-space-blueprint";
    private final SampleAttachmentCreator sampleAttachmentCreator;
    private final LabelCreator labelCreator;
    private final AppLinkCreator appLinkCreator;
    private final IndexManager indexManager;

    @Autowired
    public CreateSpaceHomePageEventListener(@ComponentImport IndexManager indexManager, SampleAttachmentCreator sampleAttachmentCreator, LabelCreator labelCreator, AppLinkCreator appLinkCreator) {
        this.indexManager = Objects.requireNonNull(indexManager);
        this.sampleAttachmentCreator = Objects.requireNonNull(sampleAttachmentCreator);
        this.labelCreator = Objects.requireNonNull(labelCreator);
        this.appLinkCreator = Objects.requireNonNull(appLinkCreator);
    }

    @EventListener
    public void onSpaceHomePageCreate(SpaceBlueprintHomePageCreateEvent event) {
        if (!SOFTWARE_PROJECT_SPACE_COMPLETE_KEY.equals(event.getSpaceBlueprint().getModuleCompleteKey())) {
            return;
        }
        Space space = event.getSpace();
        this.sampleAttachmentCreator.addSampleAttachmentsToHomePage(space);
        this.labelCreator.addLabelsToIndexPages(space);
        this.appLinkCreator.addJiraAppLink(space, event.getContext());
        try {
            this.indexManager.flushQueueWithLockTimeout(IndexManager.IndexQueueFlushMode.ONLY_FIRST_BATCH, SpaceConstants.INDEX_LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error("Failed to flush indexing queue for space home page creation", (Throwable)e);
        }
    }
}

