/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.softwareproject.components;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.link.EntityLinkBuilderFactory;
import com.atlassian.applinks.spi.link.MutatingEntityLinkService;
import com.atlassian.applinks.spi.link.ReciprocalActionException;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.confluence.plugins.ia.service.SidebarLinkService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Throwables;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppLinkCreator {
    private static final TypeId LOCAL_LINK_TYPE_ID = new TypeId("com.atlassian.applinks.api.application.confluence.ConfluenceSpaceEntityType");
    private static final TypeId REMOTE_LINK_TYPE_ID = new TypeId("jira.project");
    private static final String JIRA_PROJECT_ICON_CLASS = "jira-project";
    private final MutatingEntityLinkService entityLinkService;
    private final TypeAccessor typeAccessor;
    private final EntityLinkBuilderFactory entityLinkFactory;
    private final ApplicationLinkService applicationLinkService;
    private final SidebarLinkService sidebarLinkService;

    @Autowired
    public AppLinkCreator(@ComponentImport MutatingEntityLinkService entityLinkService, @ComponentImport TypeAccessor typeAccessor, @ComponentImport EntityLinkBuilderFactory entityLinkFactory, @ComponentImport ApplicationLinkService applicationLinkService, @ComponentImport SidebarLinkService sidebarLinkService) {
        this.entityLinkService = Objects.requireNonNull(entityLinkService);
        this.typeAccessor = Objects.requireNonNull(typeAccessor);
        this.entityLinkFactory = Objects.requireNonNull(entityLinkFactory);
        this.applicationLinkService = Objects.requireNonNull(applicationLinkService);
        this.sidebarLinkService = Objects.requireNonNull(sidebarLinkService);
    }

    public EntityLink addJiraAppLink(Space space, Map<String, Object> context) {
        try {
            EntityLink jiraLink = this.createEntityLink(space, context);
            this.sidebarLinkService.create(space.getKey(), null, jiraLink.getName(), jiraLink.getDisplayUrl().toString(), JIRA_PROJECT_ICON_CLASS);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        return null;
    }

    private EntityLink createEntityLink(Space space, Map<String, Object> context) throws Exception {
        String projectName;
        ApplicationLink applicationLink = this.getJiraApplicationLink((String)context.get("jira-server-id"));
        if (applicationLink == null) {
            return null;
        }
        String projectKey = (String)context.get("project-key");
        if (StringUtils.isBlank((CharSequence)projectKey)) {
            projectKey = space.getKey();
        }
        if (StringUtils.isBlank((CharSequence)(projectName = (String)context.get("project-name")))) {
            projectName = space.getName();
        }
        EntityType remoteType = this.typeAccessor.loadEntityType(REMOTE_LINK_TYPE_ID);
        EntityLink newLink = this.entityLinkFactory.builder().applicationLink(applicationLink).key(projectKey).name(projectName).type(remoteType).primary(false).build();
        String localKey = space.getKey();
        EntityType localType = this.typeAccessor.loadEntityType(LOCAL_LINK_TYPE_ID);
        try {
            this.entityLinkService.addReciprocatedEntityLink(localKey, localType.getClass(), newLink);
        }
        catch (ReciprocalActionException ex) {
            this.entityLinkService.addEntityLink(localKey, localType.getClass(), newLink);
        }
        return newLink;
    }

    private ApplicationLink getJiraApplicationLink(String jiraServerId) throws TypeNotInstalledException {
        ApplicationLink applicationLink;
        block2: {
            ApplicationLink link;
            applicationLink = null;
            if (StringUtils.isNotBlank((CharSequence)jiraServerId)) {
                applicationLink = this.applicationLinkService.getApplicationLink(new ApplicationId(jiraServerId));
            }
            if (applicationLink != null) break block2;
            Iterator iterator = this.applicationLinkService.getApplicationLinks(JiraApplicationType.class).iterator();
            while (iterator.hasNext() && !(applicationLink = (link = (ApplicationLink)iterator.next())).isPrimary()) {
            }
        }
        return applicationLink;
    }
}

