/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.softwareproject.components;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import io.atlassian.util.concurrent.Lazy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LabelCreator {
    private static final String BUSINESS_BLUEPRINTS_PLUGIN = "com.atlassian.confluence.plugins.confluence-business-blueprints";
    private static final String SOFTWARE_BLUEPRINTS_PLUGIN = "com.atlassian.confluence.plugins.confluence-software-blueprints";
    private static final String FILE_LISTS_MODULE_KEY = "com.atlassian.confluence.plugins.confluence-business-blueprints:file-list-blueprint";
    private static final String MEETING_NOTES_MODULE_KEY = "com.atlassian.confluence.plugins.confluence-business-blueprints:meeting-notes-blueprint";
    private static final String DECISIONS_MODULE_KEY = "com.atlassian.confluence.plugins.confluence-business-blueprints:decisions-blueprint";
    private static final String PRODUCT_REQUIREMENTS_MODULE_KEY = "com.atlassian.confluence.plugins.confluence-software-blueprints:requirements-blueprint";
    private static final String SPRINT_PLANS_MODULE_KEY = "com.atlassian.confluence.plugins.confluence-software-blueprints:jira-sprints-blueprint";
    private static final String RETROSPECTIVES_MODULE_KEY = "com.atlassian.confluence.plugins.confluence-software-blueprints:retrospectives-blueprint";
    private final LabelManager labelManager;
    private final PageManager pageManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;
    private final Supplier<Map<String, String>> moduleKeyMap = Lazy.supplier(this::buildModuleKeyMap);

    @Autowired
    public LabelCreator(@ComponentImport LabelManager labelManager, @ComponentImport PageManager pageManager, @ComponentImport I18NBeanFactory i18NBeanFactory, @ComponentImport LocaleManager localeManager) {
        this.labelManager = Objects.requireNonNull(labelManager);
        this.pageManager = Objects.requireNonNull(pageManager);
        this.i18NBeanFactory = Objects.requireNonNull(i18NBeanFactory);
        this.localeManager = Objects.requireNonNull(localeManager);
    }

    public void addLabelsToIndexPages(Space space) {
        List pages = this.pageManager.getPages(space, false);
        for (Page page : pages) {
            String pageTitle = page.getDisplayTitle();
            String nameSpace = this.moduleKeyMap.get().get(pageTitle);
            if (nameSpace == null) continue;
            Label label = new Label("blueprint-index-page", Namespace.getNamespace((String)nameSpace));
            this.labelManager.addLabel((Labelable)page, label);
        }
    }

    private Map<String, String> buildModuleKeyMap() {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean(this.localeManager.getSiteDefaultLocale());
        HashMap moduleKeyMap = Maps.newHashMap();
        moduleKeyMap.put(i18NBean.getText("confluence.blueprints.space.sp.file-lists.name"), FILE_LISTS_MODULE_KEY);
        moduleKeyMap.put(i18NBean.getText("confluence.blueprints.space.sp.meeting-notes.name"), MEETING_NOTES_MODULE_KEY);
        moduleKeyMap.put(i18NBean.getText("confluence.blueprints.space.sp.product-requirements.name"), PRODUCT_REQUIREMENTS_MODULE_KEY);
        moduleKeyMap.put(i18NBean.getText("confluence.blueprints.space.sp.decisions.name"), DECISIONS_MODULE_KEY);
        moduleKeyMap.put(i18NBean.getText("confluence.blueprints.space.sp.retrospectives.name"), RETROSPECTIVES_MODULE_KEY);
        moduleKeyMap.put(i18NBean.getText("confluence.blueprints.space.sp.sprint-plans.name"), SPRINT_PLANS_MODULE_KEY);
        return moduleKeyMap;
    }
}

