/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.nutcluster;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.impl.AbstractCacheManager;
import com.atlassian.cache.impl.ReferenceKey;
import com.atlassian.cache.impl.StrongSupplier;
import com.atlassian.cache.impl.WeakSupplier;
import com.atlassian.cache.impl.metrics.CacheManagerMetricEmitter;
import com.atlassian.cache.impl.metrics.InstrumentedCache;
import com.atlassian.cache.impl.metrics.InstrumentedCachedReference;
import com.atlassian.cache.nutcluster.CacheVersion;
import com.atlassian.cache.nutcluster.LegacyPrefixedNameFactory;
import com.atlassian.cache.nutcluster.NutclusterAsyncHybridCache;
import com.atlassian.cache.nutcluster.NutclusterAsyncHybridCachedReference;
import com.atlassian.cache.nutcluster.NutclusterCache;
import com.atlassian.cache.nutcluster.NutclusterCachedReference;
import com.atlassian.cache.nutcluster.NutclusterHybridCache;
import com.atlassian.cache.nutcluster.NutclusterHybridCachedReference;
import com.atlassian.cache.nutcluster.NutclusterMapConfigConfigurator;
import com.atlassian.cache.nutcluster.NutclusterNameFactory;
import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.ConfigurationException;
import com.atlassian.nutcluster.config.MapConfig;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.ITopic;
import com.atlassian.nutcluster.core.MembershipAdapter;
import com.atlassian.nutcluster.core.MembershipEvent;
import com.atlassian.nutcluster.core.MembershipListener;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.map.impl.MapContainer;
import com.atlassian.nutcluster.map.impl.MapService;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.map.impl.proxy.MapProxyImpl;
import com.atlassian.nutcluster.map.listener.EntryAddedListener;
import com.atlassian.nutcluster.map.listener.EntryUpdatedListener;
import com.atlassian.nutcluster.map.listener.MapListener;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.ManagedLock;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class NutclusterCacheManager
extends AbstractCacheManager {
    private static final Logger log = LoggerFactory.getLogger(NutclusterCacheManager.class);
    protected static final String SETTINGS_MAP_NAME = "atlassian-cache.settings";
    private final NutclusterInstance nutcluster;
    private final CacheFactory localCacheFactory;
    private final IMap<String, CacheSettings> mapSettings;
    private final String mapSettingsUpdatedListenerId;
    private final String mapSettingsAddedListenerId;
    private final String membershipListenerId;
    private final NutclusterNameFactory nameFactory;
    private MapServiceContext mapServiceContext;

    public NutclusterCacheManager(NutclusterInstance nutcluster, CacheFactory localCacheFactory, CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider) {
        this(nutcluster, localCacheFactory, cacheSettingsDefaultsProvider, new LegacyPrefixedNameFactory());
    }

    public NutclusterCacheManager(NutclusterInstance nutcluster, CacheFactory localCacheFactory, CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider, NutclusterNameFactory nameFactory) {
        this(nutcluster, localCacheFactory, cacheSettingsDefaultsProvider, nameFactory, new CacheManagerMetricEmitter());
    }

    @VisibleForTesting
    NutclusterCacheManager(NutclusterInstance nutcluster, CacheFactory localCacheFactory, CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider, NutclusterNameFactory nameFactory, CacheManagerMetricEmitter metricEmitter) {
        super(cacheSettingsDefaultsProvider, metricEmitter);
        this.nutcluster = Objects.requireNonNull(nutcluster);
        this.localCacheFactory = Objects.requireNonNull(localCacheFactory);
        this.nameFactory = Objects.requireNonNull(nameFactory);
        this.mapSettings = nutcluster.getMap(SETTINGS_MAP_NAME);
        this.mapSettingsUpdatedListenerId = this.mapSettings.addEntryListener((MapListener)((EntryUpdatedListener)event -> this.reconfigureMap((String)event.getKey(), (CacheSettings)event.getValue())), true);
        this.mapSettingsAddedListenerId = this.mapSettings.addEntryListener((MapListener)((EntryAddedListener)event -> this.configureMap((String)event.getKey(), (CacheSettings)event.getValue())), true);
        this.membershipListenerId = nutcluster.getCluster().addMembershipListener((MembershipListener)new MembershipAdapter(){

            public void memberAdded(MembershipEvent membershipEvent) {
                NutclusterCacheManager.this.maybeUpdateMapContainers();
            }
        });
    }

    public NutclusterInstance getNutclusterInstance() {
        return this.nutcluster;
    }

    @PostConstruct
    public void init() {
        this.maybeUpdateMapContainers();
    }

    protected <K, V> ManagedCache createComputingCache(@Nonnull String name, @Nonnull CacheSettings settings, CacheLoader<K, V> loader) {
        this.checkSettingsAreCompatible(name, settings);
        return (ManagedCache)((ManagedLock)this.cacheCreationLocks.apply(name)).withLock((java.util.function.Supplier)((Supplier)() -> {
            ManagedCache cache = null;
            if (loader == null) {
                java.util.function.Supplier cacheSupplier = (java.util.function.Supplier)this.caches.get(name);
                ManagedCache managedCache = cache = cacheSupplier == null ? null : (ManagedCache)cacheSupplier.get();
            }
            if (loader != null || cache == null) {
                cache = (ManagedCache)this.doCreateCache(name, loader, settings);
                this.caches.put(name, new WeakSupplier((Object)cache));
            }
            return cache;
        }));
    }

    protected ManagedCache createSimpleCache(@Nonnull String name, @Nonnull CacheSettings settings) {
        this.checkSettingsAreCompatible(name, settings);
        ManagedCache existing = this.getManagedCache(name);
        if (existing != null) {
            return existing;
        }
        return (ManagedCache)((ManagedLock)this.cacheCreationLocks.apply(name)).withLock((java.util.function.Supplier)((Supplier)() -> {
            if (!this.caches.containsKey(name)) {
                this.caches.put(name, new StrongSupplier((Object)((ManagedCache)this.doCreateCache(name, null, settings))));
            }
            return (ManagedCache)((java.util.function.Supplier)this.caches.get(name)).get();
        }));
    }

    @PreDestroy
    public void destroy() {
        this.mapSettings.removeEntryListener(this.mapSettingsAddedListenerId);
        this.mapSettings.removeEntryListener(this.mapSettingsUpdatedListenerId);
        this.nutcluster.getCluster().removeMembershipListener(this.membershipListenerId);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings settings) {
        CacheSettings mergedSettings = this.mergeSettings(name, settings);
        this.checkSettingsAreCompatible(name, mergedSettings);
        return (CachedReference)((ManagedLock)this.cacheCreationLocks.apply(name)).withLock((java.util.function.Supplier)((Supplier)() -> {
            ManagedCache cache = (ManagedCache)this.doCreateCachedReference(name, supplier, mergedSettings);
            this.caches.put(name, new WeakSupplier((Object)cache));
            return (CachedReference)cache;
        }));
    }

    protected void checkSettingsAreCompatible(String name, CacheSettings settings) {
    }

    public boolean updateCacheSettings(@Nonnull String mapName, @Nonnull CacheSettings newSettings) {
        try {
            MapConfig mapConfig = this.getMapConfig(mapName);
            if (mapConfig == null || !Objects.equals(mapConfig.getName(), mapName)) {
                return false;
            }
            boolean result = this.reconfigureMap(mapName, newSettings);
            if (result) {
                this.mapSettings.put((Object)mapName, (Object)this.asSerializable(newSettings));
            }
            return result;
        }
        catch (ConfigurationException exception) {
            if (log.isDebugEnabled()) {
                log.debug("Updating configuration of {} failed: ", (Object)mapName, (Object)exception);
            } else {
                log.warn("Updating cache settings on {} is not possible", (Object)mapName);
            }
            return false;
        }
    }

    protected <K, V> Cache<K, V> createAsyncHybridCache(String name, CacheLoader<K, V> loader, CacheSettings settings) {
        String topicName = this.nameFactory.getCacheInvalidationTopicName(name);
        ITopic topic = this.nutcluster.getTopic(topicName);
        return InstrumentedCache.wrap(new NutclusterAsyncHybridCache<K, V>(name, this.localCacheFactory, topic, loader, this, settings));
    }

    protected <V> CachedReference<V> createAsyncHybridCachedReference(String name, Supplier<V> supplier, CacheSettings settings) {
        String topicName = this.nameFactory.getCachedReferenceInvalidationTopicName(name);
        ITopic topic = this.nutcluster.getTopic(topicName);
        return InstrumentedCachedReference.wrap(new NutclusterAsyncHybridCachedReference<V>(name, this.localCacheFactory, (ITopic<ReferenceKey>)topic, supplier, this, settings));
    }

    protected <K, V> Cache<K, V> createDistributedCache(String name, CacheLoader<K, V> loader, CacheSettings settings) {
        String mapName = this.nameFactory.getCacheIMapName(name);
        String counterName = this.nameFactory.getCacheVersionCounterName(name);
        this.configureMap(mapName, settings);
        IMap map = this.nutcluster.getMap(mapName);
        CacheVersion cacheVersion = new CacheVersion(this.nutcluster.getAtomicLong(counterName));
        return InstrumentedCache.wrap(new NutclusterCache<K, V>(name, map, loader, cacheVersion, this));
    }

    protected <V> CachedReference<V> createDistributedCachedReference(String name, Supplier<V> supplier, CacheSettings settings) {
        CacheSettings overriddenSettings = ((CacheSettings)Preconditions.checkNotNull((Object)settings, (Object)"settings")).override(new CacheSettingsBuilder().flushable().maxEntries(1000).build());
        String mapName = this.nameFactory.getCachedReferenceIMapName(name);
        this.configureMap(mapName, overriddenSettings);
        IMap map = this.nutcluster.getMap(mapName);
        return InstrumentedCachedReference.wrap(new NutclusterCachedReference<V>(name, map, supplier, this));
    }

    protected <K, V> Cache<K, V> createHybridCache(String name, CacheLoader<K, V> loader, CacheSettings settings) {
        String mapName = this.nameFactory.getCacheIMapName(name);
        this.configureMap(mapName, settings);
        IMap map = this.nutcluster.getMap(mapName);
        return InstrumentedCache.wrap(new NutclusterHybridCache<K, V>(name, this.localCacheFactory, map, loader, this));
    }

    protected <V> CachedReference<V> createHybridCachedReference(String name, Supplier<V> supplier, CacheSettings settings) {
        String mapName = this.nameFactory.getCachedReferenceIMapName(name);
        this.configureMap(mapName, settings);
        IMap map = this.nutcluster.getMap(mapName);
        return InstrumentedCachedReference.wrap(new NutclusterHybridCachedReference<V>(name, this.localCacheFactory, (IMap<ReferenceKey, Long>)map, supplier, this));
    }

    private boolean configureMap(String mapName, CacheSettings settings) {
        Config config = this.nutcluster.getConfig();
        MapConfig mapConfig = config.findMapConfig(mapName);
        if (Objects.equals(mapConfig.getName(), mapName)) {
            log.debug("Using existing cache configuration for cache {}", (Object)mapName);
            this.mapSettings.computeIfAbsent((Object)mapName, key -> this.asSerializable(settings));
        } else {
            mapConfig = this.convertAndStoreMapConfig(mapName, settings, config, mapConfig);
            this.mapSettings.putIfAbsent((Object)mapName, (Object)this.asSerializable(settings));
        }
        return this.updateMapContainer(mapName, mapConfig);
    }

    private boolean reconfigureMap(String mapName, CacheSettings newSettings) {
        Config config = this.nutcluster.getConfig();
        MapConfig baseConfig = this.getMapConfig(mapName);
        MapConfig mapConfig = this.convertAndStoreMapConfig(mapName, newSettings, config, baseConfig);
        return this.updateMapContainer(mapName, mapConfig);
    }

    private MapConfig convertAndStoreMapConfig(String mapName, CacheSettings newSettings, Config config, MapConfig baseConfig) {
        MapConfig newConfig = new MapConfig(baseConfig);
        newConfig.setName(mapName);
        newConfig.setStatisticsEnabled(true);
        NutclusterMapConfigConfigurator.configureMapConfig(newSettings, newConfig, this.nutcluster.getPartitionService().getPartitions().size());
        MapConfig oldConfig = this.getMapConfig(mapName);
        if (oldConfig == null || !Objects.equals(oldConfig.getName(), mapName)) {
            config.addMapConfig(newConfig);
        }
        return newConfig;
    }

    private CacheSettings asSerializable(CacheSettings settings) {
        if (settings instanceof Serializable) {
            return settings;
        }
        return new CacheSettingsBuilder(settings).build();
    }

    private <K, V> Cache<K, V> doCreateCache(String name, CacheLoader<K, V> loader, CacheSettings settings) {
        if (settings.getLocal(false)) {
            return this.localCacheFactory.getCache(name, loader, settings);
        }
        if (settings.getReplicateViaCopy(true)) {
            return this.createDistributedCache(name, loader, settings);
        }
        if (settings.getReplicateAsynchronously(true)) {
            return this.createAsyncHybridCache(name, loader, settings);
        }
        return this.createHybridCache(name, loader, settings);
    }

    private <V> CachedReference<V> doCreateCachedReference(String name, Supplier<V> supplier, CacheSettings settings) {
        if (settings.getLocal(false)) {
            return this.localCacheFactory.getCachedReference(name, supplier, settings);
        }
        if (settings.getReplicateViaCopy(true)) {
            return this.createDistributedCachedReference(name, supplier, settings);
        }
        if (settings.getReplicateAsynchronously(true)) {
            return this.createAsyncHybridCachedReference(name, supplier, settings);
        }
        return this.createHybridCachedReference(name, supplier, settings);
    }

    private MapContainer getMapContainer(@Nonnull String name) {
        if (this.mapServiceContext == null) {
            MapProxyImpl proxy = (MapProxyImpl)this.nutcluster.getDistributedObject("hz:impl:mapService", SETTINGS_MAP_NAME);
            this.mapServiceContext = ((MapService)proxy.getService()).getMapServiceContext();
        }
        return this.mapServiceContext.getMapContainer(name);
    }

    private boolean updateMapContainer(String mapName, MapConfig config) {
        MapContainer container = this.getMapContainer(mapName);
        if (container == null) {
            log.debug("Map Container not found for map {}", (Object)mapName);
            return false;
        }
        container.setMapConfig(config);
        container.initEvictor();
        return true;
    }

    private void maybeUpdateMapContainers() {
        for (Map.Entry entry : this.mapSettings.entrySet()) {
            this.configureMap((String)entry.getKey(), (CacheSettings)entry.getValue());
        }
    }

    @Nullable
    MapConfig getMapConfig(@Nonnull String mapName) {
        MapContainer mapContainer = this.getMapContainer(mapName);
        MapConfig mapConfig = mapContainer.getMapConfig();
        if (!mapConfig.getName().equals(mapName)) {
            return null;
        }
        return mapConfig;
    }

    @Nullable
    CacheSettings getCacheSettings(@Nonnull String mapName) {
        return (CacheSettings)this.mapSettings.get((Object)mapName);
    }
}

