/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.nutcluster;

import com.atlassian.cache.CacheSettings;
import com.atlassian.nutcluster.config.EvictionConfig;
import com.atlassian.nutcluster.config.EvictionPolicy;
import com.atlassian.nutcluster.config.MapConfig;
import com.atlassian.nutcluster.config.MaxSizeConfig;
import com.atlassian.nutcluster.config.NearCacheConfig;
import com.atlassian.nutcluster.config.NearCachePreloaderConfig;
import java.util.Random;
import javax.annotation.Nonnull;

class NutclusterMapConfigConfigurator {
    static final int HYBRID_MULTIPLIER = 2;
    static final int SMALL_CACHES_CAPACITY_MULTIPLIER = 2;
    static final int NEAR_CACHE_EXPIRY_RATIO = Integer.getInteger("atlassian.cache.nearCacheExpiryRatio", 75);

    NutclusterMapConfigConfigurator() {
    }

    static MapConfig configureMapConfig(CacheSettings settings, MapConfig mapConfig, int partitionsCount) {
        boolean nearCache;
        Long expireAfterWrite;
        Long expireAfterAccess;
        NearCacheConfig nearCacheConfig;
        boolean hybrid = !settings.getReplicateViaCopy(true);
        Integer multiplier = hybrid ? 2 : 1;
        Integer maxEntries = settings.getMaxEntries();
        NearCacheConfig nearCacheConfig2 = nearCacheConfig = mapConfig.getNearCacheConfig() == null ? new NearCacheConfig() : NutclusterMapConfigConfigurator.copyNearCacheConfig(mapConfig.getNearCacheConfig());
        if (maxEntries != null) {
            int maxSize = NutclusterMapConfigConfigurator.adjustPerNodeCapacity(mapConfig, multiplier * maxEntries, partitionsCount);
            nearCacheConfig.setMaxSize(maxSize);
            nearCacheConfig.setEvictionPolicy(EvictionPolicy.LFU.name());
        }
        if ((expireAfterAccess = settings.getExpireAfterAccess()) != null) {
            int maxIdleSeconds = multiplier * NutclusterMapConfigConfigurator.roundUpToWholeSeconds(expireAfterAccess);
            mapConfig.setMaxIdleSeconds(maxIdleSeconds);
            int jitter = new Random().nextInt(30) - 15;
            int nearCacheTtl = (int)Math.floor((double)((NEAR_CACHE_EXPIRY_RATIO + jitter) * maxIdleSeconds) / 100.0);
            nearCacheConfig.setTimeToLiveSeconds(Math.max(1, nearCacheTtl));
        }
        if ((expireAfterWrite = settings.getExpireAfterWrite()) != null) {
            int timeToLiveSeconds = multiplier * NutclusterMapConfigConfigurator.roundUpToWholeSeconds(expireAfterWrite);
            mapConfig.setTimeToLiveSeconds(timeToLiveSeconds);
            nearCacheConfig.setTimeToLiveSeconds(timeToLiveSeconds);
        }
        if (nearCache = settings.getReplicateAsynchronously(true)) {
            mapConfig.setNearCacheConfig(nearCacheConfig);
        } else {
            mapConfig.setNearCacheConfig(null);
        }
        return mapConfig;
    }

    private static NearCacheConfig copyNearCacheConfig(@Nonnull NearCacheConfig nearCacheConfig) {
        NearCacheConfig nearCacheConfigCopy = new NearCacheConfig(nearCacheConfig);
        EvictionConfig evictionConfigCopy = new EvictionConfig(nearCacheConfig.getEvictionConfig());
        nearCacheConfigCopy.setEvictionConfig(evictionConfigCopy);
        NearCachePreloaderConfig preloaderConfigCopy = new NearCachePreloaderConfig(nearCacheConfigCopy.getPreloaderConfig());
        nearCacheConfigCopy.setPreloaderConfig(preloaderConfigCopy);
        return nearCacheConfigCopy;
    }

    private static int adjustPerNodeCapacity(MapConfig mapConfig, int desiredPerNodeSize, int partitionsCount) {
        int adjustedCacheSize = Math.max(2 * partitionsCount, desiredPerNodeSize);
        mapConfig.setMaxSizeConfig(new MaxSizeConfig().setMaxSizePolicy(MaxSizeConfig.MaxSizePolicy.PER_NODE).setSize(adjustedCacheSize));
        mapConfig.setEvictionPolicy(EvictionPolicy.LFU);
        return adjustedCacheSize;
    }

    private static int roundUpToWholeSeconds(Long expireAfterAccess) {
        return (int)Math.ceil((double)expireAfterAccess.longValue() / 1000.0);
    }
}

