/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.kubernetes;

import com.atlassian.nutcluster.kubernetes.KubernetesConfig;
import com.atlassian.nutcluster.kubernetes.NutclusterKubernetesDiscoveryStrategy;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.spi.discovery.DiscoveryNode;
import com.atlassian.nutcluster.spi.discovery.SimpleDiscoveryNode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class DnsEndpointResolver
extends NutclusterKubernetesDiscoveryStrategy.EndpointResolver {
    private static final ExecutorService DNS_LOOKUP_SERVICE = Executors.newCachedThreadPool();
    private final String serviceDns;
    private final int port;
    private final int serviceDnsTimeout;
    private final RawLookupProvider rawLookupProvider;

    DnsEndpointResolver(ILogger logger, KubernetesConfig config) {
        this(logger, config.getServiceDns(), config.getServicePort(), config.getServiceDnsTimeout(), InetAddress::getAllByName);
    }

    DnsEndpointResolver(ILogger logger, String serviceDns, int port, int serviceDnsTimeout, RawLookupProvider rawLookupProvider) {
        super(logger);
        this.serviceDns = serviceDns;
        this.port = port;
        this.serviceDnsTimeout = serviceDnsTimeout;
        this.rawLookupProvider = rawLookupProvider;
    }

    @Override
    List<DiscoveryNode> resolve() {
        try {
            return this.lookup();
        }
        catch (TimeoutException e) {
            this.logger.warning(String.format("DNS lookup for serviceDns '%s' failed: DNS resolution timeout", this.serviceDns));
            return Collections.emptyList();
        }
        catch (UnknownHostException e) {
            this.logger.warning(String.format("DNS lookup for serviceDns '%s' failed: unknown host", this.serviceDns));
            return Collections.emptyList();
        }
        catch (Exception e) {
            this.logger.warning(String.format("DNS lookup for serviceDns '%s' failed", this.serviceDns), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<DiscoveryNode> lookup() throws UnknownHostException, InterruptedException, ExecutionException, TimeoutException {
        HashSet<String> addresses = new HashSet<String>();
        Future<InetAddress[]> future = DNS_LOOKUP_SERVICE.submit(() -> this.rawLookupProvider.getAddresses(this.serviceDns));
        try {
            for (InetAddress address : future.get(this.serviceDnsTimeout, TimeUnit.SECONDS)) {
                if (!addresses.add(address.getHostAddress()) || !this.logger.isFinestEnabled()) continue;
                this.logger.finest("Found node service with address: " + String.valueOf(address));
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw (UnknownHostException)e.getCause();
            }
            throw e;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        if (addresses.isEmpty()) {
            this.logger.warning("Could not find any service for serviceDns '" + this.serviceDns + "'");
            return Collections.emptyList();
        }
        ArrayList<DiscoveryNode> result = new ArrayList<DiscoveryNode>();
        for (String address : addresses) {
            result.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(address, DnsEndpointResolver.getNutclusterPort(this.port))));
        }
        return result;
    }

    private InetAddress[] getAllInetAddresses() throws UnknownHostException {
        return InetAddress.getAllByName(this.serviceDns);
    }

    private static int getNutclusterPort(int port) {
        if (port > 0) {
            return port;
        }
        return 5701;
    }

    @FunctionalInterface
    static interface RawLookupProvider {
        public InetAddress[] getAddresses(String var1) throws UnknownHostException;
    }
}

