/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.filter;

import com.atlassian.confluence.plugins.conversion.annotation.CheckIfServiceIsEnabled;
import com.atlassian.confluence.plugins.conversion.impl.ConfigurationProperties;
import com.atlassian.plugins.capabilities.api.CapabilityService;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;

@Provider
public class CheckIfEnabledFilterFactory
implements DynamicFeature {
    private final CapabilityService capabilityService;

    @Inject
    public CheckIfEnabledFilterFactory(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (resourceInfo.getResourceMethod().isAnnotationPresent(CheckIfServiceIsEnabled.class)) {
            context.register((Object)new CheckIfEnabledFilter());
        }
    }

    private class CheckIfEnabledFilter
    implements ContainerRequestFilter,
    ContainerResponseFilter {
        private CheckIfEnabledFilter() {
        }

        public void filter(ContainerRequestContext requestContext) {
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
            if (CheckIfEnabledFilterFactory.this.capabilityService == null || !CheckIfEnabledFilterFactory.this.capabilityService.getHostApplication().hasCapability(ConfigurationProperties.PROP_CAPABILITY.toString())) {
                throw new WebApplicationException(Response.Status.GONE);
            }
        }
    }
}

