/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.impl.sandbox;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SandboxConversionFeature {
    public static final int REQUEST_TIME_LIMIT_SECS = Integer.getInteger("document.conversion.sandbox.request.time.limit.secs", 30);
    static final int MEMORY_LIMIT_MEGABYTES = Integer.getInteger("document.conversion.sandbox.memory.requirement.megabytes", 64);
    private final LicenseService licenseService;

    @Autowired
    public SandboxConversionFeature(@ComponentImport LicenseService licenseService) {
        this.licenseService = Objects.requireNonNull(licenseService);
    }

    private boolean isSandboxDisabled() {
        return Boolean.getBoolean("document.conversion.sandbox.disable");
    }

    public Boolean isEnable() {
        return this.licenseService.isLicensedForDataCenterOrExempt() && !this.isSandboxDisabled();
    }
}

