/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.conversion.annotation.CheckIfServiceIsEnabled;
import com.atlassian.confluence.plugins.conversion.annotation.ConversionPath;
import com.atlassian.confluence.plugins.conversion.api.ConversionData;
import com.atlassian.confluence.plugins.conversion.api.ConversionResult;
import com.atlassian.confluence.plugins.conversion.api.ConversionStatus;
import com.atlassian.confluence.plugins.conversion.api.ConversionType;
import com.atlassian.confluence.plugins.conversion.impl.DefaultConversionManager;
import com.atlassian.confluence.plugins.conversion.model.AttachmentDesc;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.web.rangerequest.RangeNotSatisfiableException;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@AnonymousSiteAccess
@Path(value="conversion")
public class ConfluenceConversionServiceResource {
    private static final String PARAM_ATT_ID = "attachmentId";
    private static final String PARAM_VERSION = "version";
    private final AttachmentManager attachmentManager;
    private final PermissionManager permissionManager;
    private final DefaultConversionManager conversionManager;

    @Inject
    public ConfluenceConversionServiceResource(AttachmentManager attachmentManager, PermissionManager permissionManager, DefaultConversionManager conversionManager) {
        this.attachmentManager = attachmentManager;
        this.permissionManager = permissionManager;
        this.conversionManager = conversionManager;
    }

    private Attachment getAttachment(Long attachmentId, Integer version, boolean throwIfError) {
        if (attachmentId == null || attachmentId <= 0L) {
            if (throwIfError) {
                throw ConfluenceConversionServiceResource.newWebException(Response.Status.BAD_REQUEST, "Invalid attachmentId");
            }
            return null;
        }
        if (version == null || version <= 0) {
            if (throwIfError) {
                throw ConfluenceConversionServiceResource.newWebException(Response.Status.BAD_REQUEST, "Invalid version");
            }
            return null;
        }
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId.longValue());
        if (attachment != null && attachment.getVersion() != version.intValue()) {
            attachment = this.attachmentManager.getAttachment(attachment.getContainer(), attachment.getFileName(), version.intValue());
        }
        if (attachment == null) {
            if (throwIfError) {
                throw ConfluenceConversionServiceResource.newWebException(Response.Status.NOT_FOUND, null);
            }
            return null;
        }
        if (!this.permissionManager.hasPermissionNoExemptions(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)attachment)) {
            if (throwIfError) {
                throw ConfluenceConversionServiceResource.newWebException(Response.Status.NOT_FOUND, null);
            }
            return null;
        }
        return attachment;
    }

    @Path(value="convert/{attachmentId}/{version}")
    @GET
    @ConversionPath(value=ConversionType.DOCUMENT)
    @CheckIfServiceIsEnabled
    @ScopesAllowed(requiredScope={"READ"})
    public Response getDocumentStream(@PathParam(value="attachmentId") Long attachmentId, @PathParam(value="version") Integer version, @HeaderParam(value="Range") @Nullable String rangeHeader) {
        return this.getStream(attachmentId, version, ConversionType.DOCUMENT, rangeHeader);
    }

    @Path(value="convert/results")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ConversionPath(value=ConversionType.DOCUMENT)
    @CheckIfServiceIsEnabled
    @ScopesAllowed(requiredScope={"WRITE"})
    public Map<Long, Integer> postDocumentConversionResults(List<AttachmentDesc> attachmentIds) {
        return this.getConversionResults(attachmentIds, ConversionType.DOCUMENT);
    }

    @Path(value="convertHD/{attachmentId}/{version}")
    @GET
    @ConversionPath(value=ConversionType.DOCUMENT_HD)
    @CheckIfServiceIsEnabled
    @ScopesAllowed(requiredScope={"READ"})
    public Response getDocumentStreamHD(@PathParam(value="attachmentId") Long attachmentId, @PathParam(value="version") Integer version, @HeaderParam(value="Range") @Nullable String rangeHeader) {
        return this.getStream(attachmentId, version, ConversionType.DOCUMENT_HD, rangeHeader);
    }

    @Path(value="convertHD/results")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ConversionPath(value=ConversionType.DOCUMENT_HD)
    @CheckIfServiceIsEnabled
    @ScopesAllowed(requiredScope={"WRITE"})
    public Map<Long, Integer> postDocumentConversionResultsHD(List<AttachmentDesc> attachmentIds) {
        return this.getConversionResults(attachmentIds, ConversionType.DOCUMENT_HD);
    }

    @Path(value="poster/{attachmentId}/{version}")
    @GET
    @ConversionPath(value=ConversionType.POSTER)
    @CheckIfServiceIsEnabled
    @ScopesAllowed(requiredScope={"READ"})
    public Response getPosterStream(@PathParam(value="attachmentId") Long attachmentId, @PathParam(value="version") Integer version, @HeaderParam(value="Range") @Nullable String rangeHeader) {
        return this.getStream(attachmentId, version, ConversionType.POSTER, rangeHeader);
    }

    @Path(value="poster/results")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ConversionPath(value=ConversionType.POSTER)
    @CheckIfServiceIsEnabled
    @ScopesAllowed(requiredScope={"WRITE"})
    public Map<Long, Integer> postPosterConversionResults(List<AttachmentDesc> attachmentIds) {
        return this.getConversionResults(attachmentIds, ConversionType.POSTER);
    }

    @Path(value="posterHD/{attachmentId}/{version}")
    @GET
    @ConversionPath(value=ConversionType.POSTER_HD)
    @CheckIfServiceIsEnabled
    @ScopesAllowed(requiredScope={"READ"})
    public Response getPosterStreamHD(@PathParam(value="attachmentId") Long attachmentId, @PathParam(value="version") Integer version, @HeaderParam(value="Range") @Nullable String rangeHeader) {
        return this.getStream(attachmentId, version, ConversionType.POSTER_HD, rangeHeader);
    }

    @Path(value="posterHD/results")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ConversionPath(value=ConversionType.POSTER_HD)
    @CheckIfServiceIsEnabled
    @ScopesAllowed(requiredScope={"WRITE"})
    public Map<Long, Integer> postPosterConversionResultsHD(List<AttachmentDesc> attachmentIds) {
        return this.getConversionResults(attachmentIds, ConversionType.POSTER_HD);
    }

    @Path(value="thumbnail/{attachmentId}/{version}")
    @GET
    @ConversionPath(value=ConversionType.THUMBNAIL)
    @CheckIfServiceIsEnabled
    @ScopesAllowed(requiredScope={"READ"})
    public Response getThumbnailStream(@PathParam(value="attachmentId") Long attachmentId, @PathParam(value="version") Integer version, @HeaderParam(value="Range") @Nullable String rangeHeader) {
        return this.getStream(attachmentId, version, ConversionType.THUMBNAIL, rangeHeader);
    }

    @Path(value="thumbnail/results")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ConversionPath(value=ConversionType.THUMBNAIL)
    @CheckIfServiceIsEnabled
    @ScopesAllowed(requiredScope={"WRITE"})
    public Map<Long, Integer> postThumbnailConversionResults(List<AttachmentDesc> attachmentIds) {
        return this.getConversionResults(attachmentIds, ConversionType.THUMBNAIL);
    }

    @VisibleForTesting
    Response getStream(Long attachmentId, Integer version, ConversionType conversionType, @Nullable String rangeHeader) {
        ConversionData fileData;
        Attachment attachment = this.getAttachment(attachmentId, version, true);
        ConversionResult conversionResult = this.conversionManager.getConversionResult(attachment, conversionType);
        try {
            fileData = conversionResult.getConversionData(Optional.ofNullable(rangeHeader));
        }
        catch (RangeNotSatisfiableException e) {
            return Response.status((int)416).entity((Object)"Invalid byte range specified").build();
        }
        catch (FileNotFoundException e) {
            return Response.status((int)conversionResult.getConversionStatus().getStatus()).build();
        }
        if (rangeHeader == null) {
            return Response.ok((Object)fileData.getStreamingOutput(), (String)fileData.getContentType()).header("Content-Length", (Object)fileData.getContentLength()).header("Accept-Ranges", (Object)"bytes").build();
        }
        Response.ResponseBuilder builder = Response.status((int)206).type(fileData.getContentType()).entity((Object)fileData.getStreamingOutput()).header("Content-Length", (Object)fileData.getContentLength()).header("Accept-Ranges", (Object)"bytes");
        fileData.getContentRange().ifPresent(range -> builder.header("Content-Range", range));
        return builder.build();
    }

    @VisibleForTesting
    Response getConversionResult(Long attachmentId, Integer version, ConversionType conversionType, boolean ignoreMediaTypeErrors) {
        Attachment attachment = this.getAttachment(attachmentId, version, true);
        ConversionResult conversionResult = this.conversionManager.getConversionResult(attachment, conversionType);
        if (conversionResult.getConversionStatus() != ConversionStatus.CONVERTED) {
            return Response.status((int)conversionResult.getConversionStatus().getStatus()).build();
        }
        Optional<String> contentType = conversionResult.getContentType();
        if (contentType.isEmpty()) {
            if (ignoreMediaTypeErrors) {
                contentType = Optional.of("application/octet-stream");
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Cannot convert").build();
            }
        }
        ConversionStatus conversionStatus = conversionResult.getConversionStatus();
        return Response.status((int)conversionStatus.getStatus()).type(contentType.get()).build();
    }

    private Map<Long, Integer> getConversionResults(List<AttachmentDesc> attachmentIds, ConversionType conversionType) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        for (AttachmentDesc attachmentDesc : attachmentIds) {
            Long id = attachmentDesc.getId();
            Attachment attachment = this.getAttachment(id, attachmentDesc.getValue(), false);
            if (attachment == null) {
                result.put(id, ConversionStatus.ERROR.getStatus());
                continue;
            }
            ConversionResult conversionResult = this.conversionManager.getConversionResult(attachment, conversionType);
            result.put(id, conversionResult.getConversionStatus().getStatus());
        }
        return result;
    }

    private static WebApplicationException newWebException(Response.Status status, String message) {
        return new WebApplicationException(Response.status((Response.Status)status).entity((Object)message).type("text/plain").build());
    }
}

