/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.rest;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.HashMap;
import java.util.Map;

@Priority(value=2000)
@Provider
public class RestExceptionMapper
implements ExceptionMapper<Exception> {
    public Response toResponse(Exception exception) {
        if (exception instanceof WebApplicationException) {
            WebApplicationException web = (WebApplicationException)exception;
            return web.getResponse();
        }
        return Response.status((int)500).type(MediaType.APPLICATION_JSON_TYPE).entity(RestExceptionMapper.createJson(exception)).build();
    }

    private static Map<String, Object> createJson(Exception exception) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("message", exception.getMessage());
        return result;
    }
}

