/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.consumer.sal;

import com.atlassian.secrets.api.SecretService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;

public class SecurePropertiesStore {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final String prefix;
    private final SecretService secretService;

    public SecurePropertiesStore(@Nonnull SecretService secretService, @Nonnull String prefix) {
        this.secretService = Objects.requireNonNull(secretService, "secretService");
        this.prefix = Objects.requireNonNull(prefix, "prefix");
    }

    @Nonnull
    public Optional<Properties> get(String key) {
        Objects.requireNonNull(key, "key");
        return this.secretService.get(this.prefix + "." + key).map(this::deserialize);
    }

    public void put(String key, Properties properties) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(properties, "properties");
        this.secretService.put(this.prefix + "." + key, this.serialize(properties));
    }

    private Properties deserialize(String jsonString) {
        try {
            return (Properties)objectMapper.readValue(jsonString, Properties.class);
        }
        catch (JsonProcessingException e) {
            throw new PropertiesSerializationException("Failed to deserialize string into properties object", e);
        }
    }

    public String serialize(Properties properties) {
        try {
            return objectMapper.writeValueAsString((Object)properties);
        }
        catch (JsonProcessingException e) {
            throw new PropertiesSerializationException("Failed to serialize properties object into string", e);
        }
    }

    public static class PropertiesSerializationException
    extends RuntimeException {
        public PropertiesSerializationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

