/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.consumer.sal.upgrade.v2;

import com.atlassian.confluence.plugin.PluginUpgradeFinalizationTask;
import com.atlassian.oauth.consumer.sal.upgrade.v2.ConfluenceSecureHostConsumerUpgradeTask;
import com.atlassian.oauth.consumer.sal.upgrade.v2.DefaultSecureHostConsumerUpgradeTask;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BambooOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BitbucketOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.ConfluenceOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.CrowdOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.JiraOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.RefappOnly;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.secrets.api.SecretService;
import java.util.Optional;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UpgradeTaskConfig {
    @Bean
    public PluginUpgradeTask defaultUpgradeTask(I18nResolver i18nResolver, PluginSettingsFactory pluginSettingsFactory, Optional<SecretService> secretService) {
        return new DefaultSecureHostConsumerUpgradeTask(i18nResolver, pluginSettingsFactory, secretService.orElse(null));
    }

    @Bean
    @Conditional(value={BambooOnly.class})
    public FactoryBean<ServiceRegistration> exportBambooUpgradeTask(PluginUpgradeTask defaultUpgradeTask) {
        return OsgiServices.exportOsgiService((Object)defaultUpgradeTask, (ExportOptions)ExportOptions.as(PluginUpgradeTask.class, (Class[])new Class[0]));
    }

    @Bean
    @Conditional(value={BitbucketOnly.class})
    public FactoryBean<ServiceRegistration> exportBitbucketUpgradeTask(PluginUpgradeTask defaultUpgradeTask) {
        return OsgiServices.exportOsgiService((Object)defaultUpgradeTask, (ExportOptions)ExportOptions.as(PluginUpgradeTask.class, (Class[])new Class[0]));
    }

    @Bean
    @Conditional(value={ConfluenceOnly.class})
    public FactoryBean<ServiceRegistration> exportConfluenceUpgradeTask(I18nResolver i18nResolver, PluginSettingsFactory pluginSettingsFactory, Optional<SecretService> secretService) {
        ConfluenceSecureHostConsumerUpgradeTask upradeTask = new ConfluenceSecureHostConsumerUpgradeTask(i18nResolver, pluginSettingsFactory, secretService.orElse(null));
        return OsgiServices.exportOsgiService((Object)upradeTask, (ExportOptions)ExportOptions.as(PluginUpgradeFinalizationTask.class, (Class[])new Class[0]));
    }

    @Bean
    @Conditional(value={CrowdOnly.class})
    public FactoryBean<ServiceRegistration> exportCrowdUpgradeTask(PluginUpgradeTask defaultUpgradeTask) {
        return OsgiServices.exportOsgiService((Object)defaultUpgradeTask, (ExportOptions)ExportOptions.as(PluginUpgradeTask.class, (Class[])new Class[0]));
    }

    @Bean
    @Conditional(value={JiraOnly.class})
    public FactoryBean<ServiceRegistration> exportJiraUpgradeTask(PluginUpgradeTask defaultUpgradeTask) {
        return OsgiServices.exportOsgiService((Object)defaultUpgradeTask, (ExportOptions)ExportOptions.as(PluginUpgradeTask.class, (Class[])new Class[0]));
    }

    @Bean
    @Conditional(value={RefappOnly.class})
    public FactoryBean<ServiceRegistration> exportRefappUpgradeTask(PluginUpgradeTask defaultUpgradeTask) {
        return OsgiServices.exportOsgiService((Object)defaultUpgradeTask, (ExportOptions)ExportOptions.as(PluginUpgradeTask.class, (Class[])new Class[0]));
    }
}

