/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.inlinecomments.entities;

import com.atlassian.confluence.content.ContentProperties;
import com.atlassian.confluence.core.BatchOperationManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class InlineCommentResolvedUsersBuilder {
    private static final int USERS_BATCH_SIZE = Integer.getInteger("confluence.plugin.inlinecomments.resolvedusers.executor.batchsize", 500);
    private final UserAccessor userAccessor;
    private final BatchOperationManager batchOperationManager;

    public InlineCommentResolvedUsersBuilder(UserAccessor userAccessor, BatchOperationManager batchOperationManager) {
        this.userAccessor = userAccessor;
        this.batchOperationManager = batchOperationManager;
    }

    private Set<UserKey> getResolvedUserKeys(List<Comment> comments) {
        HashSet<UserKey> userKeys = new HashSet<UserKey>();
        for (Comment comment : comments) {
            UserKey resolvedUserKey = this.getResolvedUserKey(comment);
            if (resolvedUserKey == null) continue;
            userKeys.add(resolvedUserKey);
        }
        return userKeys;
    }

    private UserKey getResolvedUserKey(Comment comment) {
        String userKey;
        String userKey2;
        ContentProperties commentProperties = comment.getProperties();
        String status = commentProperties.getStringProperty("status");
        if (status != null && StringUtils.isNotEmpty((CharSequence)(userKey2 = commentProperties.getStringProperty("status-lastmodifier")))) {
            return new UserKey(userKey2);
        }
        String resolvedProperty = commentProperties.getStringProperty("resolved");
        if (resolvedProperty != null && StringUtils.isNotEmpty((CharSequence)(userKey = commentProperties.getStringProperty("resolved-user")))) {
            return new UserKey(userKey);
        }
        return null;
    }

    private Map<String, ConfluenceUser> getResolvedUserFullNameMap(Set<UserKey> userKeys) {
        ArrayList<UserKey> userKeyList = new ArrayList<UserKey>(userKeys);
        HashMap<String, ConfluenceUser> finalUserFullNameMap = new HashMap<String, ConfluenceUser>();
        this.batchOperationManager.applyInChunks(userKeyList, USERS_BATCH_SIZE, userKeyList.size(), batch -> {
            List users = this.userAccessor.getUsersByUserKeys(batch);
            users.forEach(user -> finalUserFullNameMap.put(user.getKey().getStringValue(), (ConfluenceUser)user));
            return Collections.emptyList();
        });
        return finalUserFullNameMap;
    }

    public Map<String, ConfluenceUser> build(List<Comment> comments) {
        Set<UserKey> userKeys = this.getResolvedUserKeys(comments);
        return this.getResolvedUserFullNameMap(userKeys);
    }

    public Map<String, ConfluenceUser> build(Comment comment) {
        List<Comment> comments = Collections.singletonList(comment);
        Set<UserKey> userKeys = this.getResolvedUserKeys(comments);
        return this.getResolvedUserFullNameMap(userKeys);
    }
}

