/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.inlinecomments.notifications;

import com.atlassian.confluence.api.model.content.Container;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationUserService;
import com.atlassian.confluence.notifications.content.CommentPayload;
import com.atlassian.confluence.notifications.content.ContentRenderContextFactory;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.user.User;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractInlineCommentRenderContextFactory
extends ContentRenderContextFactory<CommentPayload> {
    private final ContentService contentService;
    private final NotificationUserService notificationUserService;
    private final ContentEntityManager contentEntityManager;
    protected final LocaleManager localeManager;

    public AbstractInlineCommentRenderContextFactory(ContentService contentService, NotificationUserService notificationUserService, ContentEntityManager contentEntityManager, LocaleManager localeManager) {
        super(CommentPayload.class);
        this.contentService = contentService;
        this.notificationUserService = notificationUserService;
        this.contentEntityManager = contentEntityManager;
        this.localeManager = localeManager;
    }

    protected Optional<NotificationContext> createForRecipient(Notification<CommentPayload> notification, ServerConfiguration serverConfiguration, RoleRecipient recipient) {
        CommentPayload payload = (CommentPayload)notification.getPayload();
        User recipientUser = this.notificationUserService.findUserForKey(recipient.getUserKey());
        ContentId contentId = ContentId.of((long)payload.getContentId());
        Content commentContent = (Content)this.contentService.find(ExpansionsParser.parse((String)"space,body.export_view,container")).withId(contentId).fetch().orElseThrow(() -> new RuntimeException(String.format("Unable to find content with id [%s], this might be because it does not exist or recipient [%s] does not have VIEW permission.", contentId, recipient.getUserKey())));
        User actionUser = this.notificationUserService.findUserByKey(recipientUser, ((CommentPayload)notification.getPayload()).getOriginatorUserKey());
        String commentContentBody = ((ContentBody)commentContent.getBody().get(ContentRepresentation.EXPORT_VIEW)).getValue();
        Container container = commentContent.getContainer();
        ContentEntityObject entity = Objects.requireNonNull(this.contentEntityManager.getById(contentId.asLong()));
        NotificationContext notificationContext = new NotificationContext();
        notificationContext.setActor(actionUser);
        notificationContext.setRecipient(recipientUser);
        notificationContext.put("content", (Object)commentContent);
        notificationContext.put("inlineContext", (Object)entity.getProperties().getStringProperty("inline-original-selection"));
        notificationContext.put("contentHtml", (Object)commentContentBody);
        notificationContext.put("page", (Object)container);
        notificationContext.put("messageId", (Object)commentContent.getId().serialise());
        Map<String, ?> enhancedContext = this.enhanceNotificationContext(actionUser, commentContentBody, container, notification, entity);
        if (enhancedContext != null && !enhancedContext.isEmpty()) {
            notificationContext.putAll(enhancedContext);
        }
        return Optional.of(notificationContext);
    }

    @Nullable
    protected abstract Map<String, ?> enhanceNotificationContext(User var1, String var2, Container var3, Notification<CommentPayload> var4, ContentEntityObject var5);
}

