/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.inlinecomments.notifications;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.notifications.PayloadTransformerTemplate;
import com.atlassian.confluence.notifications.batch.payload.BatchingPayloadTransformer;
import com.atlassian.confluence.notifications.batch.service.BatchingKey;
import com.atlassian.confluence.notifications.content.CommentPayload;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.inlinecomments.events.InlineCommentEvent;
import com.atlassian.confluence.plugins.inlinecomments.notifications.SimpleInlineCommentPayload;
import java.util.Optional;

public class DefaultInlineCommentPayloadTransformer
extends PayloadTransformerTemplate<InlineCommentEvent, CommentPayload>
implements BatchingPayloadTransformer<CommentPayload> {
    public DefaultInlineCommentPayloadTransformer() {
        super(InlineCommentEvent.class);
    }

    public Optional<CommentPayload> checkedCreate(InlineCommentEvent inlineCommentEvent) {
        if (inlineCommentEvent.isSuppressNotifications()) {
            return Optional.empty();
        }
        Comment comment = inlineCommentEvent.getComment();
        ContentEntityObject container = comment.getContainer();
        Comment parentComment = comment.getParent();
        Long parentCommentId = parentComment != null ? Long.valueOf(parentComment.getId()) : null;
        String parentInlineContext = null;
        if (parentComment != null) {
            parentInlineContext = parentComment.getProperties().getStringProperty("inline-original-selection");
        }
        SimpleInlineCommentPayload payload = new SimpleInlineCommentPayload(comment.getId(), container.getId(), container.getType(), parentCommentId, inlineCommentEvent.getUserKey());
        payload.setParentInlineContext(parentInlineContext);
        return Optional.of(payload);
    }

    public BatchingKey getBatchingColumnValue(CommentPayload payload) {
        return payload == null ? BatchingKey.NO_BATCHING : new BatchingKey(String.valueOf(payload.getContainerId()), payload.getContainerType().getType());
    }
}

