/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.inlinecomments.notifications;

import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.notifications.content.CommentPayload;
import com.atlassian.sal.api.user.UserKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class SimpleInlineCommentPayload
implements CommentPayload {
    private final long contentId;
    private final String originatingUserKey;
    private final Long parentCommentId;
    private final long containerId;
    private final ContentType containerType;
    private String parentInlineContext;

    public SimpleInlineCommentPayload() {
        this.contentId = 0L;
        this.parentCommentId = null;
        this.containerId = 0L;
        this.containerType = ContentType.valueOf((String)"");
        this.originatingUserKey = null;
    }

    @JsonCreator
    public SimpleInlineCommentPayload(@JsonProperty(value="contentId") long contentId, @JsonProperty(value="containerId") long containerId, @JsonProperty(value="containerType") String containerType, @JsonProperty(value="parentCommentId") Long parentCommentId, @JsonProperty(value="originatingUserKey") String originatingUserKey) {
        this.contentId = contentId;
        this.parentCommentId = parentCommentId;
        this.containerId = containerId;
        this.containerType = ContentType.valueOf((String)containerType);
        this.originatingUserKey = originatingUserKey;
    }

    public Optional<Long> optionalParentCommentId() {
        return Optional.ofNullable(this.parentCommentId);
    }

    public long getContainerId() {
        return this.containerId;
    }

    public Optional<String> optionalParentInlineContext() {
        return Optional.ofNullable(this.parentInlineContext);
    }

    public void setParentInlineContext(String parentInlineContext) {
        this.parentInlineContext = parentInlineContext;
    }

    public ContentType getContainerType() {
        return this.containerType;
    }

    public long getContentId() {
        return this.contentId;
    }

    public ContentType getContentType() {
        return ContentType.COMMENT;
    }

    public Optional<UserKey> getOriginatorUserKey() {
        return Optional.ofNullable(this.originatingUserKey).map(UserKey::new);
    }
}

