/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.inlinecomments.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.inlinecomments.entities.HistoryPageInlineComment;
import com.atlassian.confluence.plugins.inlinecomments.entities.InlineCommentCreationBean;
import com.atlassian.confluence.plugins.inlinecomments.entities.InlineCommentResult;
import com.atlassian.confluence.plugins.inlinecomments.entities.InlineCommentUpdateBean;
import com.atlassian.confluence.plugins.inlinecomments.entities.Reply;
import com.atlassian.confluence.plugins.inlinecomments.entities.TopLevelInlineComment;
import com.atlassian.confluence.plugins.inlinecomments.filters.InlineCommentsReadOnlyAccessFilterDynamicBinding;
import com.atlassian.confluence.plugins.inlinecomments.service.InlineCommentService;
import com.atlassian.confluence.plugins.inlinecomments.service.ReplyCommentService;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
@Path(value="comments")
@InlineCommentsReadOnlyAccessFilterDynamicBinding
public class InlineCommentResource {
    private static final Logger log = LoggerFactory.getLogger(InlineCommentResource.class);
    private final InlineCommentService inlineCommentService;
    private final ReplyCommentService replyCommentService;
    private final CaptchaManager captchaManager;
    private final HttpContext httpContext;

    @Inject
    public InlineCommentResource(InlineCommentService inlineCommentService, ReplyCommentService replyCommentService, CaptchaManager captchaManager, HttpContext httpContext) {
        this.inlineCommentService = inlineCommentService;
        this.replyCommentService = replyCommentService;
        this.captchaManager = captchaManager;
        this.httpContext = httpContext;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response createInlineComment(InlineCommentCreationBean creationBean) {
        Response captchaCheckResponse = this.checkCaptcha();
        if (captchaCheckResponse.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            return captchaCheckResponse;
        }
        return this.createComment(creationBean);
    }

    @GET
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getInlineComments(@QueryParam(value="containerId") long containerId) {
        return this.inlineCommentService.getCommentThreads(containerId).buildResponse();
    }

    @PUT
    @Path(value="/{commentId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateInlineComment(@PathParam(value="commentId") long commentId, InlineCommentUpdateBean updateInlineComment) {
        Response captchaCheckResponse = this.checkCaptcha();
        if (captchaCheckResponse.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            return captchaCheckResponse;
        }
        if (updateInlineComment != null && commentId != updateInlineComment.getId()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return this.inlineCommentService.updateComment(updateInlineComment).buildResponse();
    }

    @GET
    @Path(value="/{commentId}")
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getInlineComment(@PathParam(value="commentId") long commentId) {
        return this.inlineCommentService.getComment(commentId).buildResponse();
    }

    @DELETE
    @Path(value="/{commentId}")
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteInlineComment(@PathParam(value="commentId") long commentId) {
        return this.inlineCommentService.deleteInlineComment(commentId).buildResponse();
    }

    private Response createComment(InlineCommentCreationBean creationBean) {
        if (creationBean == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (StringUtils.isBlank((CharSequence)creationBean.getBody())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        InlineCommentService.Result result = this.inlineCommentService.create(creationBean);
        return switch (result.getStatus()) {
            case InlineCommentService.Result.Status.SUCCESS -> this.buildCommentCreationResponse(result);
            case InlineCommentService.Result.Status.NOT_PERMITTED -> Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            case InlineCommentService.Result.Status.CANNOT_MODIFY_STORAGE_FORMAT -> Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            case InlineCommentService.Result.Status.STALE_STORAGE_FORMAT -> Response.status((Response.Status)Response.Status.CONFLICT).build();
            case InlineCommentService.Result.Status.BAD_REQUEST_UTF8_MYSQL_ERROR -> Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result.getErrorMessage()).build();
            default -> Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        };
    }

    private Response buildCommentCreationResponse(InlineCommentService.Result result) {
        InlineCommentResult<TopLevelInlineComment> inlineCommentResult = this.inlineCommentService.getComment(result.getCommentId());
        if (inlineCommentResult.getStatus() == InlineCommentResult.Status.SUCCESS) {
            return inlineCommentResult.buildResponse();
        }
        log.error("Inline comment was created successfully but could not be retrieved, id is {}", (Object)result.getCommentId());
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @GET
    @Path(value="/{commentId}/replies")
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getReplies(@PathParam(value="commentId") long commentId) {
        return this.replyCommentService.getReplies(commentId).buildResponse();
    }

    @POST
    @Path(value="/{commentId}/replies")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response createReply(@PathParam(value="commentId") long commentId, Reply reply, @QueryParam(value="containerId") long containerId) {
        Response captchaCheckResponse = this.checkCaptcha();
        if (captchaCheckResponse.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            return captchaCheckResponse;
        }
        if (reply == null || commentId != reply.getCommentId()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return this.replyCommentService.createReply(reply, containerId).buildResponse();
    }

    @PUT
    @Path(value="/{commentId}/replies/{replyId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response updateReply(@PathParam(value="commentId") long commentId, @PathParam(value="replyId") long replyId, Reply reply) {
        Response captchaCheckResponse = this.checkCaptcha();
        if (captchaCheckResponse.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            return captchaCheckResponse;
        }
        if (reply == null || replyId != reply.getId()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return this.replyCommentService.updateReply(commentId, reply).buildResponse();
    }

    @DELETE
    @Path(value="/{commentId}/replies/{replyId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteReply(@PathParam(value="commentId") Long commentId, @PathParam(value="replyId") Long replyId) {
        return this.replyCommentService.deleteReply(commentId, replyId).buildResponse();
    }

    @PUT
    @Path(value="/{commentId}/resolve/{resolved}/dangling/{dangling}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response resolveInlineComment(@PathParam(value="commentId") long commentId, @PathParam(value="resolved") boolean resolved, @PathParam(value="dangling") boolean isDangling) {
        if (isDangling) {
            HistoryPageInlineComment historyComment = this.inlineCommentService.getHistoryPageComment(commentId);
            if (historyComment.getDiffVersion() == 0) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"This comment is not dangling").build();
            }
            boolean publishEvent = historyComment.getDiffVersion() <= 1;
            return this.inlineCommentService.updateResolveProperty(historyComment.getComment(), resolved, historyComment.getAbstractPage().getLastModificationDate(), historyComment.getAbstractPage().getLastModifier(), true, publishEvent).buildResponse();
        }
        return this.inlineCommentService.updateResolveProperty(commentId, resolved, new Date(), AuthenticatedUserThreadLocal.get(), false, true).buildResponse();
    }

    @GET
    @Path(value="/replies/{replyId}/commentId")
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getInlineCommentId(@PathParam(value="replyId") long replyId) {
        return this.inlineCommentService.getInlineCommentId(replyId).buildResponse();
    }

    private Response checkCaptcha() {
        HttpServletRequest request = this.httpContext.getActiveRequest();
        if (this.captchaManager.isCaptchaEnabled() && !this.captchaManager.validateCaptcha(request.getHeader("X-Atlassian-Captcha-Id"), request.getHeader("X-Atlassian-Captcha-Response"))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Captcha check failed").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Captcha check successful").build();
    }
}

