/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.inlinecomments.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.inlinecomments.service.UserStorageService;
import com.atlassian.json.jsonorg.JSONObject;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="storage")
public class StorageResource {
    private final UserStorageService userStorageService;

    @Inject
    public StorageResource(UserStorageService userStorageService) {
        this.userStorageService = userStorageService;
    }

    @PUT
    @Path(value="/{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response storeKeyForCurrentUser(@PathParam(value="key") String key) {
        this.userStorageService.storeKeyForCurrentUser(key);
        return Response.ok((Object)Response.Status.OK).build();
    }

    @GET
    @Path(value="/{key}")
    @ScopesAllowed(requiredScope={"READ"})
    public String isKeyStoredForCurrentUser(@PathParam(value="key") String key) {
        JSONObject result = new JSONObject();
        return result.put("isExist", this.userStorageService.isKeyStoredForCurrentUser(key)).toString();
    }
}

