/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.inlinecomments.service;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.service.content.ChildContentService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.OperationContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.inlinecomments.entities.InlineCommentResult;
import com.atlassian.confluence.plugins.inlinecomments.entities.Reply;
import com.atlassian.confluence.plugins.inlinecomments.events.InlineCommentReplyEvent;
import com.atlassian.confluence.plugins.inlinecomments.helper.InlineCommentPermissionHelper;
import com.atlassian.confluence.plugins.inlinecomments.service.InlineCommentAutoWatchManager;
import com.atlassian.confluence.plugins.inlinecomments.service.ReplyCommentService;
import com.atlassian.confluence.plugins.inlinecomments.utils.InlineCommentUtils;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyCommentServiceImpl
implements ReplyCommentService {
    private static final Logger log = LoggerFactory.getLogger(ReplyCommentServiceImpl.class);
    private final ChildContentService childContentService;
    private final ContentService contentService;
    private final TransactionTemplate transactionTemplate;
    private final CommentManager commentManager;
    private final InlineCommentPermissionHelper permissionHelper;
    private final InlineCommentAutoWatchManager autoWatchManager;
    private final FormatConverter formatConverter;
    private final PageManager pageManager;
    private final EventPublisher eventPublisher;

    public ReplyCommentServiceImpl(ContentService contentService, ChildContentService childContentService, TransactionTemplate transactionTemplate, CommentManager commentManager, InlineCommentPermissionHelper permissionHelper, InlineCommentAutoWatchManager autoWatchManager, FormatConverter formatConverter, PageManager pageManager, EventPublisher eventPublisher) {
        this.contentService = contentService;
        this.childContentService = childContentService;
        this.transactionTemplate = transactionTemplate;
        this.commentManager = commentManager;
        this.permissionHelper = permissionHelper;
        this.autoWatchManager = autoWatchManager;
        this.formatConverter = formatConverter;
        this.pageManager = pageManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public InlineCommentResult<List<Reply>> getReplies(long commentId) {
        Comment comment = this.commentManager.getComment(commentId);
        if (comment == null || !comment.isInlineComment()) {
            return new InlineCommentResult<List<Reply>>(InlineCommentResult.Status.REQUEST_DATA_INCORRECT);
        }
        if (!this.permissionHelper.hasViewCommentPermission((ContentEntityObject)comment)) {
            return new InlineCommentResult<List<Reply>>(InlineCommentResult.Status.NOT_PERMITTED);
        }
        try {
            PageResponse pageResponse = this.childContentService.findContent(InlineCommentUtils.buildContentId(ContentType.COMMENT, commentId), ExpansionsParser.parse((String)"history,body.view,version")).fetchMany(ContentType.COMMENT, (PageRequest)new SimplePageRequest(0, 100));
            List contents = pageResponse.getResults();
            if (contents.isEmpty()) {
                return new InlineCommentResult<List<Reply>>(InlineCommentResult.Status.SUCCESS, new ArrayList());
            }
            Comment firstComment = this.commentManager.getComment(((Content)contents.get(0)).getId().asLong());
            String pageUrl = GeneralUtil.customGetPageUrl((AbstractPage)((AbstractPage)firstComment.getContainer()));
            List replies = contents.stream().map(content -> {
                Reply reply = new Reply();
                if (content != null) {
                    reply.setId(content.getId().asLong());
                    reply.setBody(((ContentBody)content.getBody().get(ContentRepresentation.VIEW)).getValue());
                    Person person = content.getHistory().getCreatedBy();
                    reply.setAuthorInformation(person);
                    reply.setCommentId(commentId);
                    reply.setLastModificationDate(ReplyCommentServiceImpl.getDate(content.getVersion().getWhenAt()));
                    reply.setCommentDateUrl(InlineCommentUtils.getCommentDateUrl(pageUrl, reply.getId()));
                }
                return reply;
            }).collect(Collectors.toList());
            this.permissionHelper.setupPermission(replies, firstComment);
            return new InlineCommentResult<List<Reply>>(InlineCommentResult.Status.SUCCESS, replies);
        }
        catch (Exception e) {
            log.error("Failed to get replies", (Throwable)e);
            return InlineCommentResult.getResultFromServiceException(e);
        }
    }

    private static Date getDate(OffsetDateTime when) {
        return when == null ? null : Date.from(when.toInstant());
    }

    @Override
    public InlineCommentResult<Reply> createReply(Reply replyComment, Long containerId) {
        if (replyComment == null || !replyComment.isCreationBeanValid(containerId)) {
            return new InlineCommentResult<Reply>(InlineCommentResult.Status.REQUEST_DATA_INCORRECT);
        }
        Comment topLevelComment = this.commentManager.getComment(replyComment.getCommentId());
        if (topLevelComment == null || topLevelComment.getContainer().getId() != containerId.longValue()) {
            return new InlineCommentResult<Reply>(InlineCommentResult.Status.REQUEST_DATA_INCORRECT);
        }
        if (!this.permissionHelper.hasCreateCommentPermission(containerId)) {
            return new InlineCommentResult<Reply>(InlineCommentResult.Status.NOT_PERMITTED);
        }
        try {
            AbstractPage pageContainer = (AbstractPage)this.pageManager.getById(containerId.longValue());
            Comment comment = new Comment();
            comment.setBodyAsString(this.formatConverter.convertToStorageFormat(replyComment.getBody(), (RenderContext)new PageContext((ContentEntityObject)pageContainer)));
            comment.setInlineComment(true);
            pageContainer.addComment(comment);
            this.commentManager.getComment(replyComment.getCommentId()).addChild(comment);
            Content savedComment = (Content)this.transactionTemplate.execute(() -> {
                this.commentManager.saveContentEntity((ContentEntityObject)comment, DefaultSaveContext.SUPPRESS_NOTIFICATIONS);
                this.autoWatchManager.watchContentRespectingUserAutoWatchPreference(containerId);
                this.eventPublisher.publish((Object)new InlineCommentReplyEvent(this, comment, (OperationContext<?>)DefaultSaveContext.DEFAULT));
                return (Content)this.contentService.find(ExpansionsParser.parse((String)"history,version")).withId(ContentId.of((long)comment.getId())).fetchOrNull();
            });
            replyComment.setId(savedComment.getId().asLong());
            replyComment.setAuthorInformation(savedComment.getHistory().getCreatedBy());
            replyComment.setBody(this.formatConverter.convertToViewFormat(comment.getBodyAsString(), (RenderContext)new PageContext((ContentEntityObject)pageContainer)));
            replyComment.setLastModificationDate(ReplyCommentServiceImpl.getDate(savedComment.getVersion().getWhenAt()));
            String pageUrl = GeneralUtil.customGetPageUrl((AbstractPage)pageContainer);
            replyComment.setCommentDateUrl(InlineCommentUtils.getCommentDateUrl(pageUrl, replyComment.getId()));
            return new InlineCommentResult<Reply>(InlineCommentResult.Status.SUCCESS, replyComment);
        }
        catch (Exception e) {
            log.error("Error while creating a reply for the inline comment", (Throwable)e);
            return InlineCommentResult.getResultFromServiceException(e);
        }
    }

    @Override
    public InlineCommentResult deleteReply(long commentId, Long replyId) {
        Comment comment = this.commentManager.getComment(replyId.longValue());
        if (comment == null || comment.getParent() == null || comment.getParent().getId() != commentId) {
            return new InlineCommentResult(InlineCommentResult.Status.REQUEST_DATA_INCORRECT);
        }
        if (!this.commentManager.getComment(commentId).isInlineComment()) {
            return new InlineCommentResult(InlineCommentResult.Status.REQUEST_DATA_INCORRECT);
        }
        if (!this.permissionHelper.hasDeleteCommentPermission(comment)) {
            return new InlineCommentResult(InlineCommentResult.Status.NOT_PERMITTED);
        }
        try {
            return (InlineCommentResult)this.transactionTemplate.execute(() -> {
                Content reply = Content.builder((ContentType)ContentType.COMMENT, (long)replyId).build();
                this.contentService.delete(reply);
                return new InlineCommentResult(InlineCommentResult.Status.SUCCESS);
            });
        }
        catch (Exception e) {
            return InlineCommentResult.getResultFromServiceException(e);
        }
    }

    @Override
    public InlineCommentResult<Reply> updateReply(long commentId, Reply reply) {
        Comment comment = this.commentManager.getComment(reply.getId());
        if (comment == null || comment.getParent() == null || comment.getParent().getId() != commentId) {
            return new InlineCommentResult<Reply>(InlineCommentResult.Status.REQUEST_DATA_INCORRECT);
        }
        if (!this.commentManager.getComment(commentId).isInlineComment()) {
            return new InlineCommentResult<Reply>(InlineCommentResult.Status.REQUEST_DATA_INCORRECT);
        }
        if (!this.permissionHelper.hasEditCommentPermission(comment)) {
            return new InlineCommentResult<Reply>(InlineCommentResult.Status.NOT_PERMITTED);
        }
        try {
            this.commentManager.updateCommentContent(comment, this.formatConverter.convertToStorageFormat(reply.getBody(), (RenderContext)new PageContext((ContentEntityObject)comment)));
            reply.setBody(this.formatConverter.convertToViewFormat(comment.getBodyAsString(), (RenderContext)new PageContext((ContentEntityObject)comment)));
            reply.setLastModificationDate(comment.getLastModificationDate());
            reply.setCommentDateUrl(comment.getUrlPath());
            return new InlineCommentResult<Reply>(InlineCommentResult.Status.SUCCESS, reply);
        }
        catch (Exception e) {
            return InlineCommentResult.getResultFromServiceException(e);
        }
    }
}

