/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.inlinecomments.service;

import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class UserStorageService {
    public static final String USER_STORAGE_SERVICE_NAMESPACE = UserStorageService.class.getName();
    private final PluginSettingsFactory pluginSettingsFactory;
    private final String SEPARATE_CHARACTER = ",";
    private final List<String> KEY_ACCEPTED = Arrays.asList("GROW-1642", "GROW-1507");

    public UserStorageService(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public boolean isKeyStoredForCurrentUser(String key) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || StringUtils.isEmpty((CharSequence)key) || !this.KEY_ACCEPTED.contains(key)) {
            return false;
        }
        Object users = this.pluginSettingsFactory.createSettingsForKey(USER_STORAGE_SERVICE_NAMESPACE).get(key);
        return users != null && users.toString().contains(user.getName() + ",");
    }

    public void storeKeyForCurrentUser(String key) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null || StringUtils.isEmpty((CharSequence)key) || !this.KEY_ACCEPTED.contains(key)) {
            throw new BadRequestException(Response.Status.BAD_REQUEST.getReasonPhrase());
        }
        Object users = this.pluginSettingsFactory.createSettingsForKey(USER_STORAGE_SERVICE_NAMESPACE).get(key);
        if (users == null || !users.toString().contains(user.getName() + ",")) {
            this.pluginSettingsFactory.createSettingsForKey(USER_STORAGE_SERVICE_NAMESPACE).put(key, (Object)(String.valueOf(users) + user.getName() + ","));
        }
    }
}

