/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.featurediscovery.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.featurediscovery.rest.entity.FeatureItem;
import com.atlassian.confluence.plugins.featurediscovery.service.FeatureDiscoveryService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.TimePeriod;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@AnonymousSiteAccess
@Path(value="/")
public class FeatureDiscoveryResource {
    private final FeatureDiscoveryService featureDiscoveryService;
    private final PluginAccessor pluginAccessor;

    @Inject
    public FeatureDiscoveryResource(FeatureDiscoveryService featureDiscoveryService, PluginAccessor pluginAccessor) {
        this.featureDiscoveryService = featureDiscoveryService;
        this.pluginAccessor = pluginAccessor;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{context}/{key}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response isNew(@PathParam(value="context") String context, @PathParam(value="key") String key, @QueryParam(value="newPeriod") Long newPeriod) {
        boolean isNew = newPeriod == null ? this.featureDiscoveryService.isNew(context, key) : this.featureDiscoveryService.isNew(context, key, new TimePeriod(newPeriod.longValue(), TimeUnit.SECONDS));
        return Response.ok((Object)new FeatureItem(context, key, isNew)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/new")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response getNew(List<FeatureItem> features, @QueryParam(value="newPeriod") Long newPeriod) {
        List<ModuleCompleteKey> moduleCompleteKeys = this.getModuleCompleteKeys(features);
        List<ModuleCompleteKey> newModuleCompleteKeys = newPeriod == null ? this.featureDiscoveryService.getNew(moduleCompleteKeys) : this.featureDiscoveryService.getNew(moduleCompleteKeys, new TimePeriod(newPeriod.longValue(), TimeUnit.SECONDS));
        return Response.ok(this.getPluginModules(newModuleCompleteKeys)).build();
    }

    private List<ModuleCompleteKey> getModuleCompleteKeys(List<FeatureItem> pluginModules) {
        return pluginModules.stream().map(pluginModule -> new ModuleCompleteKey(pluginModule.getContext(), pluginModule.getKey())).collect(Collectors.toList());
    }

    private List<FeatureItem> getPluginModules(List<ModuleCompleteKey> newModuleCompleteKeys) {
        return newModuleCompleteKeys.stream().map(moduleCompleteKey -> new FeatureItem(moduleCompleteKey.getPluginKey(), moduleCompleteKey.getModuleKey(), true)).collect(Collectors.toList());
    }

    @GET
    @Path(value="/discovered")
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public Response getDiscoveredPluginFeatures() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok().entity(this.featureDiscoveryService.getFeaturesDiscoveredByUser(user)).build();
    }

    @POST
    @Path(value="/discovered/{pluginKey}/{featureKey}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response markPluginFeatureDiscovered(@PathParam(value="pluginKey") String pluginKey, @PathParam(value="featureKey") String featureKey) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            throw new NotFoundException();
        }
        this.featureDiscoveryService.forPlugin(plugin).markDiscovered(user, featureKey);
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/discovered/{pluginKey}/{featureKey}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response isPluginFeatureDiscovered(@PathParam(value="pluginKey") String pluginKey, @PathParam(value="featureKey") String featureKey) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        boolean isDiscovered = this.featureDiscoveryService.isFeatureDiscoveredByUser(user, pluginKey, featureKey);
        return Response.ok((Object)isDiscovered).build();
    }
}

