/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.synchrony.api.v1;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.relations.CollaboratorRelationDescriptor;
import com.atlassian.confluence.api.model.relations.Relatable;
import com.atlassian.confluence.api.model.relations.RelationDescriptor;
import com.atlassian.confluence.api.model.relations.TouchedRelationDescriptor;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ConflictException;
import com.atlassian.confluence.api.service.relations.RelationService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.synchrony.model.SynchronyError;
import com.atlassian.confluence.plugins.synchrony.service.SynchronyContentService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Strings;
import io.atlassian.fugue.Either;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/content")
@Produces(value={"application/json"})
public class EditorContentResource {
    private static final Logger log = LoggerFactory.getLogger(EditorContentResource.class);
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final DraftsTransitionHelper draftsTransitionHelper;
    private final RelationService relationService;
    private final TransactionTemplate transactionTemplate;
    private final SynchronyContentService synchronyContentService;

    @Inject
    public EditorContentResource(@ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, @ComponentImport DraftsTransitionHelper draftsTransitionHelper, @ComponentImport RelationService relationService, @ComponentImport TransactionTemplate transactionTemplate, SynchronyContentService synchronyContentService) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.draftsTransitionHelper = draftsTransitionHelper;
        this.relationService = relationService;
        this.transactionTemplate = transactionTemplate;
        this.synchronyContentService = synchronyContentService;
    }

    @Path(value="/{pageId}/changes/unpublished")
    @DELETE
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response discardToLastPublishedVersion(@PathParam(value="pageId") Long pageId) {
        AbstractPage content = this.pageManager.getAbstractPage(pageId.longValue());
        if (content != null) {
            if (!this.hasEditPermission(AuthenticatedUserThreadLocal.get(), (ContentEntityObject)content)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (content.isLatestVersion()) {
                try {
                    this.transactionTemplate.execute(() -> {
                        Either<SynchronyError, JSONObject> externalChangeResult;
                        Content draftContent = Content.builder().id(content.getContentId()).status(ContentStatus.DRAFT).build();
                        this.relationService.removeAllRelationsFromEntityWithType((RelationDescriptor)CollaboratorRelationDescriptor.COLLABORATOR, (Relatable)draftContent);
                        this.relationService.removeAllRelationsFromEntityWithType((RelationDescriptor)TouchedRelationDescriptor.TOUCHED, (Relatable)draftContent);
                        Page currentPage = this.pageManager.getPage(pageId.longValue());
                        ContentEntityObject existingDraft = this.draftsTransitionHelper.getDraft(pageId.longValue());
                        if (currentPage != null && existingDraft != null) {
                            existingDraft.setBodyAsString(currentPage.getBodyAsString());
                            this.pageManager.saveContentEntity(existingDraft, DefaultSaveContext.DRAFT);
                        }
                        if ((externalChangeResult = this.synchronyContentService.discardUnpublishedChanges(content.getContentId(), AuthenticatedUserThreadLocal.get())).isLeft()) {
                            SynchronyError error = (SynchronyError)externalChangeResult.left().get();
                            throw new RuntimeException(String.format("Rolling back removal of collaborators due to failed discard changes request to Synchrony: %s on revision %s", new Object[]{error.getCode(), error.getConflictingRev()}));
                        }
                        return null;
                    });
                }
                catch (RuntimeException e) {
                    if (e.getClass().getSimpleName().contains("HibernateOptimisticLockingFailureException")) {
                        log.debug("Editor might be busy. Unable to discard to last published version", (Throwable)e);
                        throw new ConflictException("Editor might be busy. Unable to discard to last published version", (Throwable)e);
                    }
                    log.error("Unable to discard to last published version", (Throwable)e);
                    throw new BadRequestException("Unable to discard to last published version", (Throwable)e);
                }
                return Response.status((Response.Status)Response.Status.OK).build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Content not found").build();
    }

    @Path(value="/{pageId}/recovery")
    @PUT
    @AnonymousSiteAccess
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response recoverSynchronyAndConfluence(@PathParam(value="pageId") Long pageId, @QueryParam(value="behind") Behind behind, @QueryParam(value="conflictingRev") String conflictingRev) {
        if (!this.hasEditPermission(AuthenticatedUserThreadLocal.get(), (ContentEntityObject)this.pageManager.getAbstractPage(pageId.longValue()))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        boolean result = behind == Behind.SYNCHRONY ? this.synchronyContentService.synchronyRecovery("synchrony-recovery", pageId, AuthenticatedUserThreadLocal.get()) : this.synchronyContentService.confluenceRecovery(pageId, AuthenticatedUserThreadLocal.get(), conflictingRev);
        if (!result) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private boolean hasEditPermission(ConfluenceUser user, ContentEntityObject content) {
        return this.permissionManager.hasPermission(user, Permission.EDIT, (Object)content);
    }

    public static enum Behind {
        SYNCHRONY,
        CONFLUENCE;


        @JsonCreator
        public static Behind fromString(String string) {
            if (Strings.isNullOrEmpty((String)string)) {
                return null;
            }
            return Behind.valueOf(string.toUpperCase());
        }
    }
}

