/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.synchrony.api.v1;

import com.atlassian.confluence.plugins.synchrony.api.v1.model.CollaborativeEditingSetup;
import com.atlassian.confluence.plugins.synchrony.api.v1.model.CollaborativeEditingStatus;
import com.atlassian.confluence.plugins.synchrony.config.SynchronyConfigurationManager;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Optional;

@Path(value="/config")
@AdminOnly
@Produces(value={"application/json"})
public class SynchronyConfigResource {
    private final SynchronyConfigurationManager synchronyConfigurationManager;

    @Inject
    public SynchronyConfigResource(SynchronyConfigurationManager synchronyConfigurationManager) {
        this.synchronyConfigurationManager = synchronyConfigurationManager;
    }

    @GET
    @Path(value="/status")
    public Response getStatus() {
        CollaborativeEditingStatus response = new CollaborativeEditingStatus(this.synchronyConfigurationManager.isSharedDraftsEnabled(), this.synchronyConfigurationManager.isSharedDraftsExplicitlyDisabled(), this.synchronyConfigurationManager.getExternalBaseUrl(), Optional.ofNullable(this.synchronyConfigurationManager.getConfiguredAppID()).orElse(""), this.synchronyConfigurationManager.isRegistrationComplete(), this.synchronyConfigurationManager.getSynchronyPublicKey());
        return Response.ok().entity((Object)response).build();
    }

    @PUT
    @Path(value="/setup")
    public Response doSetup() {
        CollaborativeEditingSetup response = new CollaborativeEditingSetup(this.synchronyConfigurationManager.registerWithSynchrony(), this.synchronyConfigurationManager.retrievePublicKey());
        return Response.ok().entity((Object)response).build();
    }
}

